/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.search.solr.search;

import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.search.solr.common.SearchUtils;
import com.bruce.tool.search.solr.domain.DefType;
import com.bruce.tool.search.solr.domain.FacetFields;
import com.bruce.tool.search.solr.domain.FacetQuerys;
import com.bruce.tool.search.solr.domain.FilterQuerys;
import com.bruce.tool.search.solr.domain.KeyWords;
import com.bruce.tool.search.solr.domain.PageQuery;
import com.bruce.tool.search.solr.domain.ResultType;
import com.bruce.tool.search.solr.domain.SearchResponse;
import com.bruce.tool.search.solr.domain.SuggestResponse;
import com.bruce.tool.search.solr.search.SolrSearch;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolrSearch<S, R>
implements SolrSearch {
    private static final Logger log = LoggerFactory.getLogger(AbstractSolrSearch.class);
    private PageQuery pageQuery = PageQuery.build().set(1, 50);
    private static final String[] mmValues = new String[]{"80%", "65%", "50%"};

    protected abstract SolrClient getSolrClient();

    protected abstract List<S> getSuggestBeans(QueryResponse var1);

    protected abstract List<R> getSearchBeans(QueryResponse var1);

    public final SuggestResponse<S> suggest(KeyWords keyWords) {
        return this.suggest(this.pageQuery, keyWords, FilterQuerys.build());
    }

    public final SuggestResponse<S> suggest(KeyWords keyWords, FilterQuerys querys) {
        return this.suggest(this.pageQuery, keyWords, querys);
    }

    @Override
    public final SuggestResponse<S> suggest(PageQuery pageQuery, KeyWords keyWords, FilterQuerys querys) {
        long start = System.currentTimeMillis();
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(keyWords.toString());
        SearchUtils.setPageQuery(solrQuery, pageQuery);
        SearchUtils.setFilterQuery(solrQuery, querys);
        this.setQueryDefault(solrQuery, keyWords);
        SuggestResponse<S> suggestResponse = new SuggestResponse<S>();
        QueryResponse response = this.executeLoopQuery(solrQuery);
        if (null == response) {
            return suggestResponse;
        }
        suggestResponse.setTotal(response.getResults().getNumFound());
        suggestResponse.setResponse(this.getSuggestBeans(response));
        LogUtils.info((Logger)log, (String)"\u641c\u7d22\u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - start));
        return suggestResponse;
    }

    @Override
    public final SearchResponse<R> search(PageQuery pageQuery, KeyWords keyWords, FilterQuerys filterQuerys) {
        return this.search(pageQuery, keyWords, filterQuerys, FacetQuerys.build());
    }

    @Override
    public final SearchResponse<R> search(PageQuery pageQuery, KeyWords keyWords, FilterQuerys filterQuerys, FacetQuerys facetQuerys) {
        long start = System.currentTimeMillis();
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(keyWords.toString());
        SearchUtils.setPageQuery(solrQuery, pageQuery);
        SearchUtils.setFilterQuery(solrQuery, filterQuerys);
        SearchUtils.setFacetQuery(solrQuery, facetQuerys);
        this.setQueryDefault(solrQuery, keyWords);
        SearchResponse<R> searchResponse = new SearchResponse<R>();
        QueryResponse response = this.executeLoopQuery(solrQuery);
        if (null == response) {
            return searchResponse;
        }
        searchResponse.setTotal(response.getResults().getNumFound());
        searchResponse.setResponse(this.getSearchBeans(response));
        searchResponse.setPage(pageQuery.getPage());
        searchResponse.setSize(pageQuery.getSize());
        this.fetchFacetFields(searchResponse, response);
        LogUtils.info((Logger)log, (String)"\u641c\u7d22\u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - start));
        return searchResponse;
    }

    private void fetchFacetFields(SearchResponse<R> searchResponse, QueryResponse response) {
        List list = response.getFacetFields();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        FacetFields fields = FacetFields.build();
        for (FacetField facet : list) {
            List counts = facet.getValues();
            for (FacetField.Count count : counts) {
                fields.add(facet.getName(), count.getName(), count.getCount());
            }
        }
        searchResponse.setFacetFields(fields.fetchAll());
    }

    private void setQueryDefault(SolrQuery solrQuery, KeyWords keyWords) {
        solrQuery.set("qf", new String[]{keyWords.getKey()});
        solrQuery.set("defType", new String[]{DefType.EDISMAX.name().toLowerCase()});
        solrQuery.set("wt", new String[]{ResultType.JSON.name().toLowerCase()});
        solrQuery.set("mm", new String[]{"90%"});
    }

    private QueryResponse executeLoopQuery(SolrQuery solrQuery) {
        LogUtils.info((Logger)log, (String)"\u6267\u884c\u7b2c1\u6b21\u641c\u7d22\uff0c\u641c\u7d22\u53c2\u6570\uff1a {}", (Object)solrQuery.toQueryString());
        LogUtils.info((Logger)log, (String)"\u6267\u884c\u7b2c1\u6b21\u641c\u7d22\uff0c\u5339\u914d\u5ea6\uff1a {}", (Object)"90%");
        QueryResponse response = SearchUtils.executeQuery(this.getSolrClient(), solrQuery);
        if (response == null) {
            return null;
        }
        response = this.loopQuery(solrQuery, response);
        return response;
    }

    private QueryResponse loopQuery(SolrQuery query, QueryResponse response) {
        long numFound;
        int length = mmValues.length;
        for (int i = 0; i < length && (numFound = response.getResults().getNumFound()) <= 0L; ++i) {
            query.set("mm", new String[]{mmValues[i]});
            LogUtils.info((Logger)log, (String)("\u6267\u884c\u7b2c" + (i + 2) + "\u6b21\u641c\u7d22\uff0c\u5339\u914d\u5ea6\uff1a {}"), (Object)mmValues[i]);
            response = SearchUtils.executeQuery(this.getSolrClient(), query);
        }
        return response;
    }
}

