/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.search.solr.exception;

import com.bruce.tool.common.exception.ErrorCode;
import com.bruce.tool.common.exception.I18N;

public enum SearchErrorCode {
    QUERY_HOST_ERROR("SEC_0001", "\u641c\u7d22\u670d\u52a1\u8fde\u63a5\u5931\u8d25", ""),
    QUERY_KEY_NON("SEC_0002", "\u8bf7\u5148\u8bbe\u7f6e\u67e5\u8be2\u5b57\u6bb5\u540d", ""),
    QUERY_VALUE_NOT_SUPPORT("SEC_0003", "\u8bf7\u4f20\u5165\u57fa\u672c\u6570\u636e\u7c7b\u578b\u6570\u636e", "");

    private String code;
    private String message;
    private String messageENUS;

    public static String getMessageByCode(String code, I18N i18N) {
        SearchErrorCode target = SearchErrorCode.search(code);
        if (null == target) {
            return "";
        }
        return ErrorCode.getMessageByLanguage((I18N)i18N, (String[])new String[]{target.getMessage(), target.getMessageENUS()});
    }

    public static SearchErrorCode search(String code) {
        SearchErrorCode target = null;
        for (SearchErrorCode errorCode : SearchErrorCode.values()) {
            if (!errorCode.getCode().equals(code)) continue;
            target = errorCode;
        }
        return target;
    }

    private SearchErrorCode(String code, String message, String messageENUS) {
        this.code = code;
        this.message = message;
        this.messageENUS = messageENUS;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageENUS() {
        return this.messageENUS;
    }
}

