/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.search.solr.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;

public class PageQuery
implements Serializable {
    private Integer page;
    private Integer size;
    private List<Sort> sorts = new ArrayList<Sort>();

    public PageQuery set(Integer page, Integer size) {
        this.page = page;
        this.size = size;
        return this;
    }

    public PageQuery setSort(String field, String order) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return this;
        }
        Sort sort = new Sort();
        sort.setField(field);
        this.setOrder(sort, order);
        this.sorts.clear();
        this.sorts.add(sort);
        return this;
    }

    public PageQuery addSort(String field, String order) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return this;
        }
        Sort sort = new Sort();
        sort.setField(field);
        this.setOrder(sort, order);
        this.sorts.add(sort);
        return this;
    }

    private void setOrder(Sort sort, String order) {
        if (SolrQuery.ORDER.asc.name().equals(order)) {
            sort.setOrder(SolrQuery.ORDER.asc);
        } else if (SolrQuery.ORDER.desc.name().equals(order)) {
            sort.setOrder(SolrQuery.ORDER.desc);
        } else {
            sort.setOrder(SolrQuery.ORDER.asc);
        }
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getSize() {
        return this.size;
    }

    private PageQuery() {
    }

    public static PageQuery build() {
        return new PageQuery();
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public class Sort
    implements Serializable {
        private String field;
        private SolrQuery.ORDER order;

        public String getField() {
            return this.field;
        }

        public SolrQuery.ORDER getOrder() {
            return this.order;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setOrder(SolrQuery.ORDER order) {
            this.order = order;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sort)) {
                return false;
            }
            Sort other = (Sort)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            SolrQuery.ORDER this$order = this.getOrder();
            SolrQuery.ORDER other$order = other.getOrder();
            return !(this$order == null ? other$order != null : !this$order.equals(other$order));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sort;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            SolrQuery.ORDER $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : $order.hashCode());
            return result;
        }

        public String toString() {
            return "PageQuery.Sort(field=" + this.getField() + ", order=" + this.getOrder() + ")";
        }
    }
}

