/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.search.solr.domain;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.util.ClassUtils;
import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.search.solr.domain.FilterQuery;
import com.bruce.tool.search.solr.exception.SearchErrorCode;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FilterQuerys
implements Serializable {
    private Set<FilterQuery> querys = new HashSet<FilterQuery>();

    public FilterQuerys addOne(String key, Object value) {
        if (!ClassUtils.isBaseDataType(value.getClass())) {
            throw new BaseRuntimeException((Object)SearchErrorCode.QUERY_VALUE_NOT_SUPPORT.getCode(), SearchErrorCode.QUERY_VALUE_NOT_SUPPORT.getMessage());
        }
        return this.addAll(key, FilterQuery.FORWARD, Lists.newArrayList((Object[])new Object[]{value}));
    }

    public FilterQuerys addRange(String key, Integer left, Integer right) {
        if (!ClassUtils.isBaseDataType(left.getClass()) || !ClassUtils.isBaseDataType(right.getClass())) {
            throw new BaseRuntimeException((Object)SearchErrorCode.QUERY_VALUE_NOT_SUPPORT.getCode(), SearchErrorCode.QUERY_VALUE_NOT_SUPPORT.getMessage());
        }
        String value = "[" + left + " TO " + right + "]";
        return this.addAll(key, FilterQuery.FORWARD, Lists.newArrayList((Object[])new String[]{value}));
    }

    public FilterQuerys addRange(String key, String left, String right) {
        if (!ClassUtils.isBaseDataType(left.getClass()) || !ClassUtils.isBaseDataType(right.getClass())) {
            throw new BaseRuntimeException((Object)SearchErrorCode.QUERY_VALUE_NOT_SUPPORT.getCode(), SearchErrorCode.QUERY_VALUE_NOT_SUPPORT.getMessage());
        }
        String value = left + " TO " + right;
        return this.addAll(key, FilterQuery.FORWARD, Lists.newArrayList((Object[])new String[]{value}));
    }

    public FilterQuerys addAll(String key, Collection<?> values) {
        return this.addAll(key, FilterQuery.FORWARD, values);
    }

    public FilterQuerys addAll(String key, Integer type, Collection<?> values) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new BaseRuntimeException((Object)SearchErrorCode.QUERY_KEY_NON.getCode(), SearchErrorCode.QUERY_KEY_NON.getMessage());
        }
        this.querys.add(FilterQuery.build().addAll(key, type, values));
        return this;
    }

    public Collection<FilterQuery> queries() {
        return this.querys;
    }

    private FilterQuerys() {
    }

    public static FilterQuerys build() {
        return new FilterQuerys();
    }
}

