/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.search.solr.domain;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.search.solr.domain.FacetQuerys;
import com.bruce.tool.search.solr.exception.SearchErrorCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FilterQuery
implements Serializable {
    public static final Integer FORWARD = 1;
    public static final Integer REVERSE = -1;
    private String key;
    private Integer type = FORWARD;
    private Set<Object> values = new HashSet<Object>();

    public FilterQuery type(Integer type) {
        this.type = type;
        return this;
    }

    public FilterQuery addAll(String key, Integer type, Collection<?> values) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new BaseRuntimeException((Object)SearchErrorCode.QUERY_KEY_NON.getCode(), SearchErrorCode.QUERY_KEY_NON.getMessage());
        }
        this.key = key;
        this.type = type;
        this.values.addAll(values);
        return this;
    }

    public String toString() {
        String prefix = "";
        String seperator = " or ";
        if (REVERSE.equals(this.type)) {
            prefix = "-";
            seperator = " and ";
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.values.size() == 1 && StringUtils.isBlank((CharSequence)prefix) && FacetQuerys.isEnableExclude(this.key)) {
            String query = prefix + this.key + ":" + this.values.iterator().next();
            list.add("{!tag=" + this.key + "}" + query);
        } else {
            for (Object value : this.values) {
                list.add(prefix + this.key + ":" + value);
            }
        }
        return StringUtils.join(list, (String)seperator);
    }

    private FilterQuery() {
    }

    public static FilterQuery build() {
        return new FilterQuery();
    }
}

