/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.search.solr.domain;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class FacetQuerys
implements Serializable {
    public static final Integer DEFAULT_MIN_COUNT = 1;
    private Integer minCount = DEFAULT_MIN_COUNT;
    private Set<String> facetFields = new HashSet<String>(3);
    private static ThreadLocal<Map<String, Boolean>> excludeFields = new ThreadLocal();

    public static boolean isEnableExclude(String field) {
        Map<String, Boolean> fields = excludeFields.get();
        if (null == fields) {
            return false;
        }
        Boolean enable = fields.get(field);
        return null != enable;
    }

    public static void addExcludeField(String ... fields) {
        Map<String, Boolean> exeFields = excludeFields.get();
        if (null == exeFields) {
            exeFields = new HashMap<String, Boolean>();
            excludeFields.set(exeFields);
        }
        for (String field : fields) {
            exeFields.put(field, true);
        }
    }

    public final FacetQuerys add(String ... fields) {
        this.addAll(Lists.newArrayList((Object[])fields));
        return this;
    }

    public final FacetQuerys addAll(Collection<String> fields) {
        if (!CollectionUtils.isEmpty(fields)) {
            this.facetFields.addAll(fields);
        }
        return this;
    }

    public final boolean isFacetOn() {
        return this.facetFields.size() > 0;
    }

    public final String[] toArray() {
        HashSet<String> fields = new HashSet<String>();
        for (String field : this.facetFields) {
            if (FacetQuerys.isEnableExclude(field)) {
                field = "{!ex=" + field + "}" + field;
            }
            fields.add(field);
        }
        return fields.toArray(new String[0]);
    }

    private FacetQuerys() {
    }

    public static FacetQuerys build() {
        return new FacetQuerys();
    }

    public Integer getMinCount() {
        return this.minCount;
    }
}

