/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.search.solr.config;

import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties
@ConfigurationProperties(prefix="tool.solr")
public class SolrConfig {
    private String host;

    @Bean(value={"solrClient"})
    public SolrClient solrClient() {
        return new HttpSolrClient.Builder().withBaseSolrUrl(this.host).allowCompression(true).build();
    }

    @Bean(value={"updateSolrClient"})
    public SolrClient updateSolrClient() {
        return new ConcurrentUpdateSolrClient.Builder(this.host).build();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolrConfig)) {
            return false;
        }
        SolrConfig other = (SolrConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SolrConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "SolrConfig(host=" + this.getHost() + ")";
    }
}

