/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.search.solr.common;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.search.solr.domain.FacetQuerys;
import com.bruce.tool.search.solr.domain.FilterQuery;
import com.bruce.tool.search.solr.domain.FilterQuerys;
import com.bruce.tool.search.solr.domain.PageQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchUtils {
    private static final Logger log = LoggerFactory.getLogger(SearchUtils.class);

    public static QueryResponse executeQuery(SolrClient solrClient, SolrQuery query) {
        QueryResponse response;
        try {
            if (solrClient instanceof HttpSolrClient) {
                HttpSolrClient httpSolrClient = (HttpSolrClient)solrClient;
                LogUtils.info((Logger)log, (Object)("Solr\u8bf7\u6c42\u5730\u5740\uff1a" + httpSolrClient.getBaseURL()));
            }
            response = solrClient.query((SolrParams)query);
        }
        catch (IOException | SolrServerException e) {
            throw new BaseRuntimeException((Object)e.getCause(), e.getMessage());
        }
        return response;
    }

    public static void setFilterQuery(SolrQuery solrQuery, FilterQuerys querys) {
        if (Objects.isNull(querys)) {
            return;
        }
        for (FilterQuery query : querys.queries()) {
            solrQuery.addFilterQuery(new String[]{query.toString()});
        }
    }

    public static void setFacetQuery(SolrQuery solrQuery, FacetQuerys facetQuerys) {
        if (!facetQuerys.isFacetOn()) {
            return;
        }
        solrQuery.setFacet(facetQuerys.isFacetOn());
        solrQuery.setFacetMinCount(facetQuerys.getMinCount().intValue());
        solrQuery.addFacetField(facetQuerys.toArray());
    }

    public static void setPageQuery(SolrQuery solrQuery, PageQuery pageQuery) {
        solrQuery.setStart(pageQuery.getPage()).setRows(pageQuery.getSize());
        List<PageQuery.Sort> sorts = pageQuery.getSorts();
        for (PageQuery.Sort sort : sorts) {
            solrQuery.addSort(sort.getField(), sort.getOrder());
        }
    }

    public static List<SolrInputDocument> transfer(SolrDocumentList documents) {
        ArrayList<SolrInputDocument> list = new ArrayList<SolrInputDocument>(documents.size());
        for (SolrDocument document : documents) {
            SolrInputDocument inputDocument = new SolrInputDocument(new String[0]);
            Collection fieldNames = document.getFieldNames();
            for (String fieldName : fieldNames) {
                Object value = document.getFieldValue(fieldName);
                inputDocument.addField(fieldName, value);
            }
            list.add(inputDocument);
        }
        return list;
    }

    private SearchUtils() {
    }
}

