/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.rpc.http.interceptor;

import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.rpc.http.handler.RetryHandler;
import com.bruce.tool.rpc.http.handler.response.RetryResponse;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryIntercepter
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RetryIntercepter.class);
    private int maxRetry = 3;
    private Integer[] interval = new Integer[]{50};
    private RetryHandler retryHandler;

    public RetryIntercepter(Integer maxRetry) {
        this.maxRetry = maxRetry;
    }

    public RetryIntercepter(Integer maxRetry, Integer[] interval) {
        this.maxRetry = maxRetry;
        if (Objects.nonNull(interval) && interval.length > 0) {
            this.interval = interval;
        }
    }

    public RetryIntercepter(Integer maxRetry, RetryHandler retryHandler) {
        this.retryHandler = retryHandler;
        this.maxRetry = maxRetry;
    }

    public RetryIntercepter(Integer maxRetry, Integer[] interval, RetryHandler retryHandler) {
        this.retryHandler = retryHandler;
        this.maxRetry = maxRetry;
        if (Objects.nonNull(interval) && interval.length > 0) {
            this.interval = interval;
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (SocketTimeoutException e) {
            response = this.timeoutRetry(chain, request);
        }
        if (Objects.isNull(this.retryHandler)) {
            return this.serverErrorRetry(chain, request, response);
        }
        byte[] content = response.body().bytes();
        MediaType mediaType = response.body().contentType();
        RetryResponse retryResponse = this.retryHandler.needRetry(content);
        if (Objects.nonNull(retryResponse) && retryResponse.getNeed().booleanValue()) {
            for (int i = 0; i < this.maxRetry && !Objects.isNull(retryResponse = this.retryHandler.needRetry(content = (response = this.requestAgain(chain, request, i, retryResponse.getReason())).body().bytes())) && retryResponse.getNeed().booleanValue(); ++i) {
            }
        }
        return response.newBuilder().body(ResponseBody.create((MediaType)mediaType, (byte[])content)).build();
    }

    private Response serverErrorRetry(Interceptor.Chain chain, Request request, Response response) throws IOException {
        if (Objects.nonNull(response) && response.code() >= 500) {
            for (int i = 0; i < this.maxRetry && !Objects.isNull(response = this.requestAgain(chain, request, i, "HTTP\u72b6\u6001\u7801:" + response.code())) && response.code() >= 500; ++i) {
            }
        }
        return response;
    }

    private Response timeoutRetry(Interceptor.Chain chain, Request request) throws IOException {
        Response response = null;
        for (int i = 0; i < this.maxRetry; ++i) {
            try {
                response = this.requestAgain(chain, request, i, "\u63a5\u53e3\u8bbf\u95ee\u8d85\u65f6");
                break;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
        }
        if (Objects.isNull(response)) {
            throw new SocketTimeoutException("\u91cd\u8bd5" + this.maxRetry + "\u4e4b\u540e,\u4ecd\u7136\u8d85\u65f6,\u7ec8\u6b62\u5c1d\u8bd5.");
        }
        return response;
    }

    private Response requestAgain(Interceptor.Chain chain, Request request, Integer index, String reason) throws IOException {
        try {
            Integer delayTime = index > this.interval.length - 1 ? this.interval[this.interval.length - 1] : this.interval[index];
            Thread.sleep(delayTime.intValue());
            LogUtils.debug((Logger)log, (String)"\u7b2c{}\u6b21\u91cd\u65b0\u53d1\u9001\u8bf7\u6c42,\u5ef6\u8fdf\u65f6\u95f4:{},\u91cd\u8bd5\u539f\u56e0: {}", (Object[])new Object[]{index + 1, delayTime, reason});
        }
        catch (InterruptedException e) {
            LogUtils.error((Logger)log, (Object)e);
            Thread.currentThread().interrupt();
        }
        return chain.proceed(request);
    }
}

