/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.rpc.http.interceptor;

import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.rpc.http.core.Https;
import com.bruce.tool.rpc.http.handler.LogInfo;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class LogInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long startTime = System.currentTimeMillis();
        LogInfo logInfo = Https.getLogInfo();
        StringBuilder requester = new StringBuilder().append("{").append("\"method\":\"").append(request.method()).append("\",").append("\"url\":\"").append(request.url().toString()).append("\"").append("}");
        logInfo.setRequestInfo(requester.toString());
        Response response = chain.proceed(chain.request());
        long duration = System.currentTimeMillis() - startTime;
        MediaType mediaType = response.body().contentType();
        byte[] content = response.body().bytes();
        if (HttpStatus.OK.value() != response.code()) {
            this.gatherErrorInfo(logInfo, new String(content), response);
        } else {
            this.gatherResponseInfo(logInfo, mediaType, content);
        }
        logInfo.setEnd("-----------------End:" + duration + "\u6beb\u79d2-----------------\n");
        this.print(logInfo);
        Https.removeLogInfo();
        return response.newBuilder().body(ResponseBody.create((MediaType)mediaType, (byte[])content)).build();
    }

    private void print(LogInfo logInfo) {
        LogUtils.debug((String)"{}", (Object)logInfo.getBegin());
        if (StringUtils.isNotBlank((CharSequence)logInfo.getRequestInfo())) {
            LogUtils.debug((String)"\u8bf7\u6c42\u4fe1\u606f:{}", (Object)logInfo.getRequestInfo());
        }
        if (StringUtils.isNotBlank((CharSequence)logInfo.getHeaderInfo())) {
            LogUtils.debug((String)"\u3000\u8bf7\u6c42\u5934:{}", (Object)logInfo.getHeaderInfo());
        }
        if (StringUtils.isNotBlank((CharSequence)logInfo.getUrlParams())) {
            LogUtils.debug((String)"url\u53c2\u6570:{}", (Object)logInfo.getUrlParams());
        }
        if (StringUtils.isNotBlank((CharSequence)logInfo.getBodyParams())) {
            LogUtils.debug((String)"body\u53c2\u6570:{}", (Object)logInfo.getBodyParams());
        }
        if (StringUtils.isNotBlank((CharSequence)logInfo.getResponseInfo())) {
            LogUtils.debug((String)"\u8fd4\u56de\u7ed3\u679c:{}", (Object)logInfo.getResponseInfo());
        }
        LogUtils.debug((String)"{}", (Object)logInfo.getEnd());
    }

    private void gatherErrorInfo(LogInfo logInfo, String content, Response response) {
        if (StringUtils.isNotBlank((CharSequence)content) && content.length() > 1024) {
            content = content.substring(0, 1024);
        }
        String message = "HTTP\u72b6\u6001\u7801:" + response.code() + ",\u9519\u8bef\u4fe1\u606f:" + content;
        logInfo.setResponseInfo(message);
    }

    private void gatherResponseInfo(LogInfo logInfo, MediaType mediaType, byte[] content) {
        String mediaTypeString = mediaType.toString();
        if (!(mediaTypeString.contains("application/json") || mediaTypeString.contains("text/xml") || mediaTypeString.contains("text/html") || mediaTypeString.contains("text/plain") || mediaTypeString.contains("text/asp"))) {
            logInfo.setResponseInfo("\u6587\u4ef6\u7c7b\u578b:" + mediaTypeString + ",\u6587\u4ef6\u5927\u5c0f:" + content.length);
        } else {
            String result = StringUtils.unicode2str((String)new String(content));
            logInfo.setResponseInfo(result);
        }
    }
}

