/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.rpc.http.handler.sign;

import com.bruce.tool.rpc.http.constant.HttpErrorCode;
import com.bruce.tool.rpc.http.exception.HttpRuntimeException;
import com.bruce.tool.rpc.http.handler.SignHandler;
import com.bruce.tool.rpc.http.handler.request.RequestInfo;
import com.bruce.tool.rpc.http.handler.sign.SignInfo;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignAdapter
implements SignHandler {
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    protected String signKey;
    static final DateTimeFormatter DT_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss");
    static final ZoneId ZONE_GMT = ZoneId.of("Z");

    @Override
    public void sign(SignInfo signInfo, RequestInfo requestInfo) {
    }

    protected final byte[] signature(String appSecretKey, String paramStitch, String arithmeticName) {
        Mac hmacSha = this.crypto(appSecretKey, arithmeticName);
        byte[] hash = hmacSha.doFinal(paramStitch.getBytes(StandardCharsets.UTF_8));
        return hash;
    }

    protected String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    protected String bytesToBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    protected final Mac crypto(String input, String arithmeticName) {
        Mac hmacSha256;
        try {
            hmacSha256 = Mac.getInstance(arithmeticName);
            SecretKeySpec secKey = new SecretKeySpec(input.getBytes(StandardCharsets.UTF_8), arithmeticName);
            hmacSha256.init(secKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpRuntimeException((Object)HttpErrorCode.ERROR_HTTP.getCode(), "No such algorithm: " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new HttpRuntimeException((Object)HttpErrorCode.ERROR_HTTP.getCode(), "Invalid key: " + e.getMessage());
        }
        return hmacSha256;
    }

    protected final long epochNow() {
        return Instant.now().getEpochSecond();
    }

    protected final String gmtNow() {
        return Instant.ofEpochSecond(this.epochNow()).atZone(ZONE_GMT).format(DT_FORMAT);
    }
}

