/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.rpc.http.handler.response;

import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.rpc.http.constant.HttpErrorCode;
import com.bruce.tool.rpc.http.core.Https;
import com.bruce.tool.rpc.http.exception.HttpRuntimeException;
import com.bruce.tool.rpc.http.handler.response.ResponseAdapter;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteResponseHandler
extends ResponseAdapter<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(ByteResponseHandler.class);

    @Override
    public byte[] handle(Response response) throws IOException {
        ResponseBody body = response.body();
        if (Objects.isNull(body)) {
            return new byte[0];
        }
        String contentType = response.header("Content-Type");
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return new byte[]{0};
        }
        if (contentType.contains(Https.JSON.subtype())) {
            byte[] result = body.bytes();
            Map object = (Map)JsonUtils.strToObj((String)new String(result), Map.class);
            if (result.length > 0) {
                Object message = object.get("message");
                throw new HttpRuntimeException((Object)HttpErrorCode.ERROR_BUSINESS.getCode(), String.valueOf(message));
            }
            return result;
        }
        return body.bytes();
    }
}

