/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.rpc.http.core;

import com.bruce.tool.common.util.regex.RegexUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.common.util.string.XmlUtils;
import com.bruce.tool.rpc.http.constant.HttpErrorCode;
import com.bruce.tool.rpc.http.exception.HttpRuntimeException;
import com.bruce.tool.rpc.http.handler.LogInfo;
import com.bruce.tool.rpc.http.handler.ResponseHandler;
import com.bruce.tool.rpc.http.handler.RetryHandler;
import com.bruce.tool.rpc.http.handler.SignHandler;
import com.bruce.tool.rpc.http.handler.Timeout;
import com.bruce.tool.rpc.http.handler.request.RequestInfo;
import com.bruce.tool.rpc.http.handler.request.RequestType;
import com.bruce.tool.rpc.http.handler.response.ByteResponseHandler;
import com.bruce.tool.rpc.http.handler.response.DefaultResponseHandler;
import com.bruce.tool.rpc.http.handler.response.PingResponseHandler;
import com.bruce.tool.rpc.http.handler.sign.SignInfo;
import com.bruce.tool.rpc.http.handler.ssl.SSLAllHandler;
import com.bruce.tool.rpc.http.handler.ssl.SSLSpecifiedHandler;
import com.bruce.tool.rpc.http.handler.ssl.TrustAllManager;
import com.bruce.tool.rpc.http.interceptor.LogInterceptor;
import com.bruce.tool.rpc.http.interceptor.RetryIntercepter;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import javax.validation.constraints.NotNull;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class Https {
    private static final Logger log = LoggerFactory.getLogger(Https.class);
    public static final ThreadLocal<LogInfo> httpLogInfo = new ThreadLocal();
    public static final MediaType TEXT = MediaType.parse((String)"text/plain; charset=utf-8");
    public static final MediaType HTML = MediaType.parse((String)"text/html; charset=utf-8");
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType XML = MediaType.parse((String)"application/xml;charset=UTF-8");
    public static final MediaType DATA = MediaType.parse((String)"application/octet-stream;charset=UTF-8");
    public static final String REQUEST_TAG = "tool-rpc-http";
    private Timeout timeout = Timeout.builder().connectTimeout(5).writeTimeout(5).readTimeout(5).build();
    private TimeUnit unit = TimeUnit.SECONDS;
    private boolean print = true;
    private boolean retry = false;
    private String url;
    private boolean ping = false;
    private HttpUrl httpUrl;
    private boolean sort = false;
    private boolean encode = true;
    private String cert;
    private String password;
    private Integer maxRetry = 3;
    private Integer[] interval = new Integer[]{500};
    private RetryHandler retryHandler;
    private SignInfo signInfo;
    private SignHandler signHandler;
    private Map<String, Object> urlParams = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, Object> bodyParams = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, Object> headerParams = Collections.synchronizedMap(new LinkedHashMap());

    protected OkHttpClient build() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (this.print) {
            builder.addInterceptor((Interceptor)new LogInterceptor());
        }
        builder.connectTimeout((long)this.timeout.getConnectTimeout().intValue(), this.unit).writeTimeout((long)this.timeout.getWriteTimeout().intValue(), this.unit).readTimeout((long)this.timeout.getReadTimeout().intValue(), this.unit);
        if (this.retry) {
            if (Objects.nonNull(this.retryHandler)) {
                builder.addInterceptor((Interceptor)new RetryIntercepter(this.maxRetry, this.interval, this.retryHandler));
            } else {
                builder.addInterceptor((Interceptor)new RetryIntercepter(this.maxRetry, this.interval));
            }
        }
        if (!this.httpUrl.isHttps()) {
            return builder.build();
        }
        if (StringUtils.isNotBlank((CharSequence)this.cert)) {
            SSLSpecifiedHandler handler = SSLSpecifiedHandler.build();
            builder.sslSocketFactory(handler.factory(this.cert, this.password), handler.trustManager()).hostnameVerifier((s, sslSession) -> true);
        } else {
            builder.sslSocketFactory(SSLAllHandler.factory(), (X509TrustManager)new TrustAllManager()).hostnameVerifier((s, sslSession) -> true);
        }
        return builder.build();
    }

    public Https timeout(Timeout timeout) {
        this.timeout = timeout;
        return this;
    }

    public Https timeout(Integer connect, Integer read, Integer write) {
        this.timeout.setConnectTimeout(connect);
        this.timeout.setWriteTimeout(write);
        this.timeout.setReadTimeout(read);
        return this;
    }

    public Https retry(boolean retry) {
        this.retry = retry;
        return this;
    }

    public Https retry(Integer maxRetry) {
        this.retry = true;
        this.maxRetry = maxRetry;
        return this;
    }

    public Https retry(Integer maxRetry, Integer[] interval) {
        this.retry = true;
        this.maxRetry = maxRetry;
        if (Objects.nonNull(interval) && interval.length > 0) {
            this.interval = interval;
        }
        return this;
    }

    public Https retry(RetryHandler retryHandler) {
        this.retry = true;
        this.retryHandler = retryHandler;
        return this;
    }

    public Https retry(Integer maxRetry, RetryHandler retryHandler) {
        this.retry = true;
        this.maxRetry = maxRetry;
        this.retryHandler = retryHandler;
        return this;
    }

    public Https retry(Integer maxRetry, Integer[] interval, RetryHandler retryHandler) {
        this.retry = true;
        this.maxRetry = maxRetry;
        this.retryHandler = retryHandler;
        if (Objects.nonNull(interval) && interval.length > 0) {
            this.interval = interval;
        }
        return this;
    }

    public Https print(boolean print) {
        this.print = print;
        return this;
    }

    public Https sort(boolean sort) {
        this.sort = sort;
        return this;
    }

    public Https encode(boolean encode) {
        this.encode = encode;
        return this;
    }

    public Https ping(boolean ping) {
        this.ping = ping;
        return this;
    }

    public Https url(String url) {
        this.url = url;
        this.httpUrl = HttpUrl.parse((String)url);
        return this;
    }

    public Https cert(String cert, String password) {
        this.cert = cert;
        this.password = password;
        return this;
    }

    public Https add(String key, @NotNull Object value) {
        this.urlParams.put(key, value);
        return this;
    }

    public Https addAll(Map<String, Object> urlParams) {
        if (CollectionUtils.isEmpty(urlParams)) {
            return this;
        }
        this.urlParams.putAll(urlParams);
        return this;
    }

    public Https addBody(String key, @NotNull Object value) {
        this.bodyParams.put(key, value);
        return this;
    }

    public Https addAllBodys(Map<String, Object> bodyParams) {
        if (CollectionUtils.isEmpty(bodyParams)) {
            return this;
        }
        this.bodyParams.putAll(bodyParams);
        return this;
    }

    public Https addHeader(String key, @NotNull Object value) {
        this.headerParams.put(key, value);
        return this;
    }

    public Https addAllHeaders(Map<String, Object> headerParams) {
        if (CollectionUtils.isEmpty(headerParams)) {
            return this;
        }
        this.headerParams.putAll(headerParams);
        return this;
    }

    public Https simple(String url, Map<String, Object> urlParams) {
        this.url = url;
        this.urlParams = urlParams;
        return this;
    }

    public Https simple(String url, Map<String, Object> urlParams, Map<String, Object> headerParams) {
        this.url = url;
        this.urlParams = urlParams;
        this.headerParams.putAll(headerParams);
        return this;
    }

    public Https simple(String url, Map<String, Object> urlParams, Map<String, Object> bodyParams, Map<String, Object> headerParams) {
        this.url = url;
        this.urlParams.putAll(urlParams);
        this.bodyParams.putAll(bodyParams);
        this.headerParams.putAll(headerParams);
        return this;
    }

    public Https signature(SignInfo signInfo, SignHandler signHandler) {
        this.signInfo = signInfo;
        this.signHandler = signHandler;
        return this;
    }

    public String get() {
        return this.execute(RequestMethod.GET, RequestType.URL);
    }

    public String put() {
        return this.execute(RequestMethod.PUT, RequestType.FORM);
    }

    public String putJson() {
        return this.execute(RequestMethod.PUT, RequestType.JSON);
    }

    public String putXml() {
        return this.execute(RequestMethod.PUT, RequestType.XML);
    }

    public String delete() {
        return this.execute(RequestMethod.DELETE, RequestType.FORM);
    }

    public String deleteJson() {
        return this.execute(RequestMethod.DELETE, RequestType.JSON);
    }

    public String deleteXml() {
        return this.execute(RequestMethod.DELETE, RequestType.XML);
    }

    public String post() {
        return this.execute(RequestMethod.POST, RequestType.FORM);
    }

    public String postJson() {
        return this.execute(RequestMethod.POST, RequestType.JSON);
    }

    public String postXml() {
        return this.execute(RequestMethod.POST, RequestType.XML);
    }

    public byte[] download() {
        return this.execute(RequestMethod.GET, RequestType.URL, new ByteResponseHandler());
    }

    public String upload() {
        return this.execute(RequestMethod.POST, RequestType.FILE, new DefaultResponseHandler());
    }

    private void signature(RequestMethod method) {
        if (null == this.signHandler) {
            return;
        }
        RequestInfo requestInfo = RequestInfo.builder().method(method).httpUrl(this.httpUrl).urlParams(this.urlParams).bodyParams(this.bodyParams).headerParams(this.headerParams).build();
        this.signHandler.sign(this.signInfo, requestInfo);
    }

    public String execute(RequestMethod method, RequestType requestType) {
        if (this.ping) {
            return String.valueOf(this.execute(method, requestType, new PingResponseHandler()));
        }
        return this.execute(method, requestType, new DefaultResponseHandler());
    }

    public <T> T execute(RequestMethod method, RequestType requestType, ResponseHandler<T> handler) {
        if (StringUtils.isBlank((CharSequence)this.url)) {
            throw new HttpRuntimeException((Object)HttpErrorCode.URL_IS_NULL.getCode(), HttpErrorCode.URL_IS_NULL.getMessage());
        }
        this.signature(method);
        Request.Builder requestBuilder = new Request.Builder();
        this.handleHeaders(this.headerParams, requestBuilder);
        this.handleUrlParams(this.urlParams);
        if (RequestType.FORM.equals((Object)requestType)) {
            this.handleBodyParams(this.bodyParams, requestBuilder, method);
        } else if (RequestType.JSON.equals((Object)requestType)) {
            this.handleJsonParams(this.bodyParams, requestBuilder, method);
        } else if (RequestType.XML.equals((Object)requestType)) {
            this.handleXmlParams(this.bodyParams, requestBuilder, method);
        } else if (RequestType.FILE.equals((Object)requestType)) {
            this.handleFileParams(this.bodyParams, requestBuilder, method);
        }
        requestBuilder.tag((Object)REQUEST_TAG).url(this.url);
        return this.execute(requestBuilder, handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Request.Builder builder, ResponseHandler<T> responseHandler) {
        OkHttpClient client = this.build();
        Request request = builder.build();
        if (this.print) {
            this.gatherLogInfo();
        }
        try (Response response = client.newCall(request).execute();){
            T t = responseHandler.handle(response);
            return t;
        }
        catch (Exception e) {
            throw new HttpRuntimeException(e);
        }
    }

    private void gatherLogInfo() {
        LogInfo logInfo = Https.getLogInfo();
        logInfo.setBegin("--------------------start--------------------");
        if (!CollectionUtils.isEmpty(this.headerParams)) {
            logInfo.setHeaderInfo(JsonUtils.objToStr(this.headerParams));
        }
        if (!CollectionUtils.isEmpty(this.urlParams)) {
            logInfo.setUrlParams(JsonUtils.objToStr(this.urlParams));
        }
        if (!CollectionUtils.isEmpty(this.bodyParams)) {
            for (Map.Entry<String, Object> entry : this.bodyParams.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof byte[]) {
                    this.bodyParams.put(entry.getKey(), "byte\u6570\u7ec4\u957f\u5ea6:" + ((byte[])value).length);
                    continue;
                }
                if (!(value instanceof File)) continue;
                File file = (File)value;
                this.bodyParams.put(entry.getKey(), "\u6587\u4ef6\u540d:" + file.getName() + "\u6587\u4ef6\u5927\u5c0f:" + file.length());
            }
            logInfo.setBodyParams(JsonUtils.objToStr(this.bodyParams));
        }
    }

    private void handleHeaders(Map<String, ?> headerParams, Request.Builder requestBuilder) {
        if (CollectionUtils.isEmpty(headerParams)) {
            return;
        }
        Headers.Builder headerBuilder = new Headers.Builder();
        for (Map.Entry<String, ?> entry : headerParams.entrySet()) {
            if (Objects.isNull(entry.getValue())) continue;
            headerBuilder.add(entry.getKey(), String.valueOf(entry.getValue()));
        }
        requestBuilder.headers(headerBuilder.build());
    }

    private void handleUrlParams(Map<String, Object> urlParams) {
        if (CollectionUtils.isEmpty(urlParams)) {
            return;
        }
        String params = this.sort ? Https.sortParams(this.urlParams, this.encode) : Https.jointParams(this.urlParams, this.encode);
        if (StringUtils.isNotBlank((CharSequence)params)) {
            this.url = this.url + "?" + params;
        }
        if (RegexUtils.containsMore((String)this.url, (String)"(\\?)", (Integer)2)) {
            throw new HttpRuntimeException((Object)HttpErrorCode.ERROR_HTTP.getCode(), "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef,\u51fa\u73b0\u591a\u4e2a?.");
        }
    }

    private void handleBodyParams(Map<String, ?> bodyParams, Request.Builder requestBuilder, RequestMethod method) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        for (Map.Entry<String, ?> entry : bodyParams.entrySet()) {
            if (Objects.isNull(entry.getValue())) continue;
            formBuilder.add(entry.getKey(), String.valueOf(entry.getValue()));
        }
        this.handlerRequestMethod(requestBuilder, method, (RequestBody)formBuilder.build());
    }

    private void handleJsonParams(Map<String, Object> bodyParams, Request.Builder requestBuilder, RequestMethod method) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)JsonUtils.objToStr(bodyParams));
        this.handlerRequestMethod(requestBuilder, method, body);
    }

    private void handleXmlParams(Map<String, Object> bodyParams, Request.Builder requestBuilder, RequestMethod method) {
        RequestBody body = RequestBody.create((MediaType)XML, (String)XmlUtils.toXml(bodyParams));
        this.handlerRequestMethod(requestBuilder, method, body);
    }

    private void handleFileParams(Map<String, Object> bodyParams, Request.Builder requestBuilder, RequestMethod method) {
        MultipartBody.Builder formBuilder = new MultipartBody.Builder();
        formBuilder.setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> entry : bodyParams.entrySet()) {
            if (Objects.isNull(entry.getValue())) continue;
            Object object = entry.getValue();
            if (object instanceof File) {
                File file = (File)entry.getValue();
                formBuilder.addFormDataPart(entry.getKey(), file.getName(), RequestBody.create((MediaType)DATA, (File)file));
                continue;
            }
            if (object instanceof byte[]) {
                byte[] data = (byte[])entry.getValue();
                formBuilder.addFormDataPart(entry.getKey(), "file", RequestBody.create((MediaType)DATA, (byte[])data));
                continue;
            }
            formBuilder.addFormDataPart(entry.getKey(), String.valueOf(entry.getValue()));
        }
        this.handlerRequestMethod(requestBuilder, method, (RequestBody)formBuilder.build());
    }

    private void handlerRequestMethod(Request.Builder requestBuilder, RequestMethod method, RequestBody build) {
        if (RequestMethod.POST.equals((Object)method)) {
            requestBuilder.post(build);
        }
        if (RequestMethod.PUT.equals((Object)method)) {
            requestBuilder.put(build);
        }
        if (RequestMethod.DELETE.equals((Object)method)) {
            requestBuilder.delete(build);
        }
    }

    public static String jointParams(Map<String, Object> params) {
        return Https.jointParams(params, false);
    }

    public static String jointParams(Map<String, Object> params, boolean encode) {
        StringBuilder sb = new StringBuilder(1024);
        Map<String, Object> map = Collections.synchronizedMap(params);
        return Https.loopParams(encode, sb, map.entrySet());
    }

    public static String sortParams(Map<String, Object> params) {
        return Https.sortParams(params, false);
    }

    public static String sortParams(Map<String, Object> params, boolean encode) {
        StringBuilder sb = new StringBuilder(1024);
        SortedMap<String, Object> map = Collections.synchronizedSortedMap(new TreeMap<String, Object>(params));
        return Https.loopParams(encode, sb, map.entrySet());
    }

    private static String loopParams(boolean encode, StringBuilder sb, Set<Map.Entry<String, Object>> entries) {
        for (Map.Entry<String, Object> entry : entries) {
            if (!Objects.nonNull(entry.getValue())) continue;
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            if (encode) {
                value = Https.urlEncode(value);
            }
            sb.append(key).append('=').append(value).append('&');
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static LogInfo getLogInfo() {
        LogInfo logInfo = httpLogInfo.get();
        if (Objects.isNull(logInfo)) {
            logInfo = new LogInfo();
            httpLogInfo.set(logInfo);
        }
        return logInfo;
    }

    public static void removeLogInfo() {
        httpLogInfo.remove();
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF-8 encoding not supported!");
        }
    }

    private Https() {
    }

    public static Https create() {
        return new Https();
    }
}

