/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.quartz.core;

import com.bruce.tool.common.exception.ExceptionUtils;
import com.bruce.tool.quartz.domain.QuartzEntity;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class QuartzService {
    private static final Logger log = LoggerFactory.getLogger(QuartzService.class);
    @Autowired
    @Qualifier(value="Scheduler")
    private Scheduler scheduler;

    public void save(QuartzEntity quartz) {
        try {
            CronExpression cronExpression = new CronExpression(quartz.getCronExpression());
            Class<?> cls = Class.forName(quartz.getJobClassName());
            if (quartz.getOldJobGroup() != null) {
                JobKey key = new JobKey(quartz.getOldJobName(), quartz.getOldJobGroup());
                this.scheduler.deleteJob(key);
            }
            JobDetail job = JobBuilder.newJob(cls).withIdentity(quartz.getJobName(), quartz.getJobGroup()).usingJobData("triggerUrl", quartz.getTriggerUrl()).usingJobData("statusUrl", quartz.getStatusUrl()).withDescription(quartz.getDescription()).build();
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((CronExpression)cronExpression);
            Trigger trigger = TriggerBuilder.newTrigger().withDescription(quartz.getCronExpression()).withIdentity(quartz.getTriggerName(), quartz.getJobGroup()).startNow().withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (ClassNotFoundException | ParseException | SchedulerException e) {
            ExceptionUtils.printStackTrace((Throwable)e);
        }
    }

    public void delete(String jobName, String jobGroup) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            this.scheduler.pauseTrigger(triggerKey);
            this.scheduler.unscheduleJob(triggerKey);
            this.scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            ExceptionUtils.printStackTrace((Throwable)e);
        }
    }

    public List<QuartzEntity> findAll() {
        ArrayList<QuartzEntity> list = new ArrayList<QuartzEntity>();
        try {
            GroupMatcher matcher = GroupMatcher.anyJobGroup();
            Set jobKeys = this.scheduler.getJobKeys(matcher);
            this.getJobs(jobKeys, list);
        }
        catch (SchedulerException e) {
            ExceptionUtils.printStackTrace((Throwable)e);
        }
        return list;
    }

    public void trigger(String jobName, String jobGroup) {
        try {
            JobKey key = new JobKey(jobName, jobGroup);
            this.scheduler.triggerJob(key);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public void pause(String jobName, String jobGroup) {
        try {
            JobKey key = new JobKey(jobName, jobGroup);
            this.scheduler.pauseJob(key);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public void resume(String jobName, String jobGroup) {
        try {
            JobKey key = new JobKey(jobName, jobGroup);
            this.scheduler.resumeJob(key);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    private void getJobs(Set<JobKey> jobKeys, List<QuartzEntity> list) throws SchedulerException {
        for (JobKey jobKey : jobKeys) {
            List triggers = this.scheduler.getTriggersOfJob(jobKey);
            for (Trigger trigger : triggers) {
                QuartzEntity job = new QuartzEntity();
                job.setJobName(jobKey.getName());
                job.setJobGroup(jobKey.getGroup());
                JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                String className = jobDetail.getJobClass().getName();
                job.setJobClassName(className);
                job.setDescription(jobDetail.getDescription());
                String triggerUrl = jobDetail.getJobDataMap().getString("triggerUrl");
                String statusUrl = jobDetail.getJobDataMap().getString("statusUrl");
                job.setTriggerUrl(triggerUrl);
                job.setStatusUrl(statusUrl);
                Trigger.TriggerState triggerState = this.scheduler.getTriggerState(trigger.getKey());
                job.setTriggerState(triggerState.name());
                if (trigger instanceof CronTrigger) {
                    CronTrigger cronTrigger = (CronTrigger)trigger;
                    String cronExpression = cronTrigger.getCronExpression();
                    job.setCronExpression(cronExpression);
                    job.setTriggerName(trigger.getKey().getName());
                }
                list.add(job);
            }
        }
    }
}

