/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.push.aliyun.core;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.push.model.v20160801.PushRequest;
import com.aliyuncs.push.model.v20160801.PushResponse;
import com.aliyuncs.utils.ParameterHelper;
import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.exception.ExceptionUtils;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.common.util.valid.ValidUtils;
import com.bruce.tool.push.aliyun.config.AliyunPusherConfig;
import com.bruce.tool.push.aliyun.constant.DeviceType;
import com.bruce.tool.push.aliyun.constant.OpenType;
import com.bruce.tool.push.aliyun.constant.PushErrorCode;
import com.bruce.tool.push.aliyun.constant.Target;
import com.bruce.tool.push.aliyun.core.Message;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public abstract class AliyunPusher {
    private static final Logger log = LoggerFactory.getLogger(AliyunPusher.class);
    @Autowired
    protected AliyunPusherConfig aliyunPusherConfig;

    public boolean push2ios(Message message) {
        return this.execute(Target.DEVICE, DeviceType.IOS, message);
    }

    public boolean push2android(Message message) {
        return this.execute(Target.DEVICE, DeviceType.ANDROID, message);
    }

    public boolean push2device(Message message) {
        return this.execute(Target.DEVICE, DeviceType.ALL, message);
    }

    public boolean push2account(Message message) {
        return this.execute(Target.ACCOUNT, DeviceType.ALL, message);
    }

    public boolean push2alias(Message message) {
        return this.execute(Target.ALIAS, DeviceType.ALL, message);
    }

    public boolean push2tag(Message message) {
        return this.execute(Target.TAG, DeviceType.ALL, message);
    }

    public boolean push2all(Message message) {
        return this.execute(Target.ALL, DeviceType.ALL, message);
    }

    public boolean execute(Target target, DeviceType deviceType, Message message) {
        ValidUtils.valid((Object)this.aliyunPusherConfig);
        ValidUtils.valid((Object)message);
        return this.push(this.initRequest(target, deviceType, message));
    }

    private boolean push(PushRequest pushRequest) {
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)this.aliyunPusherConfig.getRegionId(), (String)this.aliyunPusherConfig.getAccessKeyId(), (String)this.aliyunPusherConfig.getAccessKeySecret());
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            PushResponse pushResponse = (PushResponse)client.getAcsResponse((AcsRequest)pushRequest);
            LogUtils.info((Logger)log, (String)"\u6d88\u606f\u63a8\u9001,\u8fd4\u56de\u7ed3\u679c:{}", (Object)JsonUtils.objToStr((Object)pushResponse));
            return true;
        }
        catch (Exception e) {
            ExceptionUtils.printStackTrace((Throwable)e);
            return false;
        }
    }

    private PushRequest initRequest(Target target, DeviceType deviceType, Message message) {
        PushRequest pushRequest = new PushRequest();
        this.initTarget(message, pushRequest, target, deviceType);
        this.initMessage(message, pushRequest);
        this.initDeviceInfo(message, pushRequest, deviceType);
        this.initPushConfig(message, pushRequest);
        return pushRequest;
    }

    private void initPushConfig(Message message, PushRequest pushRequest) {
        String expireTime;
        String pushTime;
        Date pushDate;
        if (Objects.nonNull(message.getStoreOffline())) {
            pushRequest.setStoreOffline(message.getStoreOffline());
        }
        if (Objects.nonNull(this.aliyunPusherConfig.getDelay())) {
            pushDate = new Date(System.currentTimeMillis() + message.getDelay() * 1000L);
            pushTime = ParameterHelper.getISO8601Time((Date)pushDate);
            pushRequest.setPushTime(pushTime);
        }
        if (Objects.nonNull(message.getDelay())) {
            pushDate = new Date(System.currentTimeMillis() + message.getDelay() * 1000L);
            pushTime = ParameterHelper.getISO8601Time((Date)pushDate);
            pushRequest.setPushTime(pushTime);
        }
        if (Objects.nonNull(this.aliyunPusherConfig.getExpire())) {
            expireTime = ParameterHelper.getISO8601Time((Date)new Date(System.currentTimeMillis() + this.aliyunPusherConfig.getExpire() * 3600L * 1000L));
            pushRequest.setExpireTime(expireTime);
        }
        if (Objects.nonNull(message.getExpire())) {
            expireTime = ParameterHelper.getISO8601Time((Date)new Date(System.currentTimeMillis() + message.getExpire() * 3600L * 1000L));
            pushRequest.setExpireTime(expireTime);
        }
    }

    private void initDeviceInfo(Message message, PushRequest pushRequest, DeviceType deviceType) {
        if (DeviceType.IOS.equals((Object)deviceType) || DeviceType.ALL.equals((Object)deviceType)) {
            pushRequest.setIOSBadge(message.getIOSBadge());
            pushRequest.setIOSSilentNotification(Boolean.valueOf(false));
            pushRequest.setIOSMusic(message.getIOSMusic());
            pushRequest.setIOSSubtitle(message.getIOSSubTitle());
            pushRequest.setIOSNotificationCategory("iOS10 Notification Category");
            pushRequest.setIOSMutableContent(Boolean.valueOf(true));
            pushRequest.setIOSRemind(Boolean.valueOf(true));
            pushRequest.setIOSRemindBody("iOSRemindBody");
            pushRequest.setIOSExtParameters(message.getIOSExt());
            if (StringUtils.isNotBlank((CharSequence)this.aliyunPusherConfig.getIOSApnsEnv())) {
                pushRequest.setIOSApnsEnv(this.aliyunPusherConfig.getIOSApnsEnv());
            }
            if (Objects.nonNull((Object)message.getIOSApnsEnv())) {
                pushRequest.setIOSApnsEnv(message.getIOSApnsEnv().name());
            }
        }
        if (DeviceType.ANDROID.equals((Object)deviceType) || DeviceType.ALL.equals((Object)deviceType)) {
            pushRequest.setAndroidNotifyType(message.getNotifyType().name());
            pushRequest.setAndroidNotificationBarType(Integer.valueOf(1));
            pushRequest.setAndroidNotificationBarPriority(Integer.valueOf(1));
            pushRequest.setAndroidOpenType(message.getOpenType().name());
            pushRequest.setAndroidMusic(message.getAndroidMusic());
            if (OpenType.ACTIVITY.equals((Object)message.getOpenType())) {
                pushRequest.setAndroidActivity(message.getAndroidActivity());
            } else if (OpenType.URL.equals((Object)message.getOpenType())) {
                pushRequest.setAndroidOpenUrl(message.getAndroidUrl());
            }
            if (StringUtils.isNotBlank((CharSequence)message.getAndroidExt())) {
                pushRequest.setAndroidExtParameters(message.getAndroidExt());
            }
        }
    }

    private void initMessage(Message message, PushRequest pushRequest) {
        pushRequest.setPushType(message.getMessageType().name());
        pushRequest.setTitle(message.getTitle());
        pushRequest.setBody(message.getMessage());
    }

    private void initTarget(Message message, PushRequest pushRequest, Target target, DeviceType deviceType) {
        String appKeys = this.aliyunPusherConfig.getAppKeys();
        if (!appKeys.contains(",")) {
            pushRequest.setAppKey(Long.valueOf(appKeys));
        } else {
            List keys = StringUtils.splitToList((String)appKeys, (String)",");
            if (CollectionUtils.isEmpty((Collection)keys)) {
                throw new BaseRuntimeException((Object)PushErrorCode.PE0001.name(), "\u63a8\u9001Appkey\u5f02\u5e38,\u8bf7\u68c0\u67e5\u914d\u7f6e");
            }
            if (keys.size() == 1) {
                pushRequest.setAppKey(Long.valueOf((String)keys.get(0)));
            }
            pushRequest.setAppKey(this.getAppKey(keys));
        }
        pushRequest.setProtocol(ProtocolType.HTTPS);
        pushRequest.setMethod(MethodType.POST);
        pushRequest.setDeviceType(deviceType.name());
        pushRequest.setTarget(target.name());
        pushRequest.setTargetValue(message.getTargetValue());
    }

    public Long getAppKey(List<String> keys) {
        return Long.valueOf(keys.get(0));
    }
}

