package com.bruce.tool.office.excel.util;

import com.bruce.tool.common.util.file.IOUtils;
import com.bruce.tool.office.excel.extend.ExcelToHtmlConverter;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import org.apache.poi.ss.usermodel.Workbook;
import org.w3c.dom.Document;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 功能 :
 *
 * @author : Bruce(刘正航) 8:20 PM 2018/12/8
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class ContentUtils {

    /**将Excel文件流转换成html字符串**/
    public static String transfer(InputStream in) throws IOException, ParserConfigurationException, TransformerException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }

        Document doc = process(in);

        if(Objects.isNull(doc) ){ return null; }

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(baos);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        // TODO set encoding from a command argument
        serializer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
        serializer.setOutputProperty(OutputKeys.INDENT, "no");
        serializer.setOutputProperty(OutputKeys.METHOD, "html");
        serializer.transform(domSource, streamResult);
        return new String(baos.toByteArray(), "UTF-8");
    }

    /**转换成Document**/
    public static Document process(InputStream in) throws ParserConfigurationException {
        Workbook workbook = null;
        try {
            workbook = WorkBookUtils.create(in);
            //公式的自动计算
            workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
            ExcelToHtmlConverter converter = new ExcelToHtmlConverter(
                    DocumentBuilderFactory
                            .newInstance()
                            .newDocumentBuilder()
                            .newDocument()
            );
            converter.setOutputColumnHeaders(false);
            converter.setOutputRowNumbers(false);
            converter.processWorkbook(workbook);
            return converter.getDocument();
        } finally {
            IOUtils.closeQuietly(workbook,in);
        }
    }

    /**设置表格宽度,避免样式走样**/
    public static String setTableWidth(String content) {
        List<Integer> tableWidths = new ArrayList<>();

        gatherTableWidth(tableWidths,content);

        for (Integer tableWidth : tableWidths) {
            content = content.replaceFirst("<table class=\"t1\">", "<table class=\"t1\" width=\""+tableWidth+"\">");
        }

        return content;
    }

    /**搜集表宽度**/
    private static void gatherTableWidth(List<Integer> tableWithds, String content) {
        Pattern p1 = Pattern.compile("(<colgroup>[<col width=\"0-9>]+</colgroup>)");
        Matcher m1 = p1.matcher(content);
        List<String> colgroups = new ArrayList<>();
        while (m1.find()) {
            for (int i = 0; i < m1.groupCount(); i++) {
                String test1 = m1.group(i);
                colgroups.add(test1);
            }
        }

        for ( String colgroup : colgroups ) {
            Pattern p2 = Pattern.compile("(<col width=\"[0-9]+\">)");
            Matcher m2 = p2.matcher(colgroup);
            int widths = 0;
            while (m2.find()) {
                String width = m2.group();
                width = width.replace("<col width=\"", "");
                width = width.replace("\">", "");
                widths += Integer.parseInt(width);
            }
            tableWithds.add(widths);
        }
    }
}
