/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.netty.socket.core;

import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.common.util.string.MapHandler;
import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.netty.socket.core.SocketServer;
import com.bruce.tool.netty.socket.util.SocketUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@ChannelHandler.Sharable
public class SocketServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SocketServerHandler.class);
    private SocketServer server;
    private Map<String, Channel> clients = Maps.newConcurrentMap();
    private List<Channel> servers = Lists.newArrayList();

    public SocketServerHandler(SocketServer server) {
        this.server = server;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof ByteBuf)) {
            return;
        }
        String message = SocketUtils.transfer((ByteBuf)msg);
        if (StringUtils.isEmpty((CharSequence)message)) {
            return;
        }
        Channel incoming = ctx.channel();
        if (message.contains(this.server.getConfig().getPing())) {
            LogUtils.info((Logger)log, (String)"\u5fc3\u8df3\u68c0\u6d4b:{}", (Object)message);
            Map ping = (Map)JsonUtils.strToObj((String)message, Map.class);
            String clientKey = (String)ping.get(this.server.getConfig().getPing());
            if (StringUtils.isNotBlank((CharSequence)clientKey)) {
                if (clientKey.startsWith("server")) {
                    this.servers.add(incoming);
                } else {
                    this.clients.put(clientKey, incoming);
                }
            }
            MapHandler body = MapHandler.build().add(this.server.getConfig().getPong(), (Object)"\u670d\u52a1\u5668\u56de\u590d\u5fc3\u8df3");
            message = JsonUtils.objToStr((Object)body);
            msg = Unpooled.copiedBuffer((byte[])message.getBytes());
            incoming.writeAndFlush(msg);
            return;
        }
        Map data = (Map)JsonUtils.strToObj((String)message, Map.class);
        if (CollectionUtils.isEmpty((Map)data)) {
            LogUtils.debug((Logger)log, (Object)"\u9519\u8bef\u7684\u6d88\u606f\u683c\u5f0f");
            return;
        }
        String clientKey = (String)data.get(this.server.getConfig().getKey());
        if (StringUtils.isBlank((CharSequence)clientKey)) {
            LogUtils.debug((Logger)log, (Object)"\u9519\u8bef\u7684\u6d88\u606f\u683c\u5f0f,\u7f3a\u5c11\u5ba2\u6237\u7aefKey");
            return;
        }
        Object isServer = data.get("isServer");
        if (Objects.nonNull(isServer)) {
            Channel channel = this.clients.get(clientKey);
            if (Objects.nonNull(channel)) {
                channel.writeAndFlush(msg);
            }
        } else {
            Integer size = this.servers.size();
            Channel channel = this.servers.get((int)(Math.random() * (double)size.intValue()));
            if (Objects.nonNull(channel)) {
                channel.writeAndFlush(msg);
            }
        }
    }
}

