/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.netty.socket.core;

import com.bruce.tool.netty.socket.config.NettySocketConfig;
import com.bruce.tool.netty.socket.core.SocketServerHandler;
import com.bruce.tool.netty.socket.core.Start;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SocketServer
implements Start {
    @Autowired
    private NettySocketConfig config;
    private final SocketServerHandler handler = new SocketServerHandler(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws InterruptedException {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{SocketServer.this.handler});
                }
            });
            ChannelFuture f = b.bind(this.config.getPort().intValue()).sync();
            Channel channel = f.channel();
            channel.closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }

    public NettySocketConfig getConfig() {
        return this.config;
    }
}

