/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.netty.socket.core;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.common.util.string.MapHandler;
import com.bruce.tool.netty.socket.constant.NettyErrorCode;
import com.bruce.tool.netty.socket.core.SocketClient;
import com.bruce.tool.netty.socket.util.SocketUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SocketClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SocketClientHandler.class);
    private SocketClient client;

    public SocketClientHandler(SocketClient client) {
        this.client = client;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof ByteBuf)) {
            return;
        }
        String message = SocketUtils.transfer((ByteBuf)msg);
        if (message.contains(this.client.config().getPong())) {
            LogUtils.info((Logger)log, (String)"\u5fc3\u8df3\u68c0\u6d4b:{}", (Object)message);
        } else {
            if (Objects.isNull(this.client.getListener())) {
                throw new BaseRuntimeException((Object)NettyErrorCode.NTERROR_CONFIG_NULL.getCode(), "\u76d1\u542c\u5668\u672a\u521d\u59cb\u5316");
            }
            this.client.getListener().listen(message);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.client.connect();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (!(evt instanceof IdleStateEvent)) {
            return;
        }
        IdleStateEvent e = (IdleStateEvent)evt;
        switch (e.state()) {
            case READER_IDLE: {
                this.handleReaderIdle(ctx);
                break;
            }
            case WRITER_IDLE: {
                this.handleWriterIdle(ctx);
                break;
            }
            case ALL_IDLE: {
                this.handleAllIdle(ctx);
                break;
            }
        }
    }

    private void handleReaderIdle(ChannelHandlerContext ctx) {
        ctx.close();
    }

    private void handleWriterIdle(ChannelHandlerContext ctx) {
    }

    private void handleAllIdle(ChannelHandlerContext ctx) {
        MapHandler body = MapHandler.build().add(this.client.config().getPing(), (Object)this.client.config().getUniqueNo());
        String message = JsonUtils.objToStr((Object)body);
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])message.getBytes()));
    }
}

