/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.netty.socket.core;

import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.common.util.string.MapHandler;
import com.bruce.tool.netty.socket.config.NettySocketConfig;
import com.bruce.tool.netty.socket.core.MessageListener;
import com.bruce.tool.netty.socket.core.SocketClientHandler;
import com.bruce.tool.netty.socket.core.Start;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SocketClient
implements Start {
    private static final Logger log = LoggerFactory.getLogger(SocketClient.class);
    @Autowired
    private NettySocketConfig config;
    private Channel channel;
    private final Bootstrap bs = new Bootstrap();
    private final SocketClientHandler handler = new SocketClientHandler(this);
    private MessageListener listener;

    public void addListener(MessageListener listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        NioEventLoopGroup group = new NioEventLoopGroup();
        ((Bootstrap)((Bootstrap)this.bs.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).remoteAddress(this.config.getHost(), this.config.getPort().intValue()).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(SocketClient.this.config.getTimeout().intValue(), 0, 0)});
                ch.pipeline().addLast(new ChannelHandler[]{SocketClient.this.handler});
            }
        });
        this.connect();
    }

    void connect() {
        ChannelFuture channelFuture = this.bs.connect().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                MapHandler body = MapHandler.build().add(this.config.getPing(), (Object)this.config.getUniqueNo());
                String message = JsonUtils.objToStr((Object)body);
                future.channel().writeAndFlush((Object)Unpooled.copiedBuffer((byte[])message.getBytes()));
                return;
            }
            LogUtils.error((Logger)log, (String)"\u8fde\u63a5\u5931\u8d25:{}", (Object)future.cause().getMessage());
            future.channel().eventLoop().schedule(this::connect, 10L, TimeUnit.SECONDS);
        }));
        this.channel = channelFuture.channel();
    }

    public void send(String message) {
        if (Objects.nonNull(this.channel)) {
            this.channel.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])message.getBytes()));
        }
    }

    public NettySocketConfig config() {
        return this.config;
    }

    public MessageListener getListener() {
        return this.listener;
    }
}

