package com.bruce.tool.netty.socket.config;

import com.bruce.tool.common.util.random.Random;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 功能 :
 *
 * @author : Bruce(刘正航) 10:32 2019-03-10
 */
@Data
@Component
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "tool.netty.socket")
public class NettySocketConfig {
    private String host;
    private Integer port;
    private Integer retry;
    private Integer timeout;
    // 客户端唯一标识
    private String uniqueNo = "server_"+ Random.character(6);
    private String ping = "ping";
    private String pong = "pong";
    private String key = "key";
}
