/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.service.manager;

import com.bruce.tool.common.util.ClassUtils;
import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.mybatis.orm.mapper.BaseMapper;
import com.bruce.tool.mybatis.orm.query.CriteriaQuery;
import com.bruce.tool.mybatis.orm.util.TableUtils;
import com.bruce.tool.mybatis.service.dto.Page;
import com.bruce.tool.mybatis.service.form.Groupable;
import com.bruce.tool.mybatis.service.form.Idsable;
import com.bruce.tool.mybatis.service.form.Limitable;
import com.bruce.tool.mybatis.service.form.Orderable;
import com.bruce.tool.mybatis.service.manager.PageHandler;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public abstract class BaseManager<F, D> {
    protected abstract Class<D> clazz();

    protected abstract BaseMapper<D> baseMapper();

    protected abstract CriteriaQuery buildCriteria(F var1);

    public Integer save(D domain) {
        return this.baseMapper().save(domain);
    }

    public Integer saveAll(List<D> list) {
        return this.baseMapper().saveAll(list);
    }

    public Integer saveBySQL(String sql) {
        return this.baseMapper().saveBySQL(sql);
    }

    public Integer deleteByDomainId(D domain) {
        return this.baseMapper().deleteByDomainId(domain);
    }

    public Integer deleteById(Object id) {
        return this.baseMapper().deleteById(this.clazz(), id);
    }

    public Integer deleteByColumn(String column, Object value) {
        return this.baseMapper().deleteByColumn(this.clazz(), column, value);
    }

    public Integer deleteByColumns(D domain) {
        return this.baseMapper().deleteByColumns(domain);
    }

    public Integer deleteBySQL(String sql) {
        return this.baseMapper().deleteBySQL(sql);
    }

    public Integer markDeleteById(Object id) {
        return this.baseMapper().markDeleteById(this.clazz(), id);
    }

    public Integer markDeleteByIdDiy(Object id, String mark) {
        return this.baseMapper().markDeleteByIdDiy(this.clazz(), id, mark);
    }

    public Integer update(D domain) {
        return this.baseMapper().update(domain);
    }

    public Integer updateBySelective(D domain) {
        return this.baseMapper().updateBySelective(domain);
    }

    public Integer updateAll(List<D> list) {
        return this.baseMapper().updateAll(list);
    }

    public Integer updateBySQL(String sql) {
        return this.baseMapper().updateBySQL(sql);
    }

    public D findByDomain(D domain) {
        return (D)this.baseMapper().findByDomainId(domain);
    }

    public D findById(Object id) {
        return (D)this.baseMapper().findById(this.clazz(), id);
    }

    public D findByColumn(String key, Object value) {
        return (D)this.baseMapper().findByColumn(this.clazz(), key, value);
    }

    public D findByColumns(D domain) {
        return (D)this.baseMapper().findByColumns(domain);
    }

    public Map findByColumnsTableCriteria(String columns, String table, F form) {
        return this.baseMapper().findByColumnsTableCriteria(columns, table, this.buildCriteria2(form));
    }

    public Map findBySQLCriteria(String sql, F form) {
        return this.baseMapper().findBySQLCriteria(sql, this.buildCriteria2(form));
    }

    public Map findBySQL(String sql) {
        return this.baseMapper().findBySQL(sql);
    }

    public List<D> findsByColumn(String key, Object value) {
        return this.baseMapper().findsByColumn(this.clazz(), key, value);
    }

    public List<D> findsByColumns(D domain) {
        return this.baseMapper().findsByColumns(domain);
    }

    public List<D> findsByCriteria(F form) {
        return this.baseMapper().findsByCriteria(this.clazz(), this.buildCriteria2(form));
    }

    public List<Map> findsByColumnsTableCriteria(String columns, String table, F form) {
        return this.baseMapper().findsByColumnsTableCriteria(columns, table, this.buildCriteria2(form));
    }

    public List<Map> findsBySQLCriteria(String sql, F form) {
        return this.baseMapper().findsBySQLCriteria(sql, this.buildCriteria2(form));
    }

    public List<Map> findsBySQL(String sql) {
        return this.baseMapper().findsBySQL(sql);
    }

    public Page<D> findPageByColumn(String key, Object value, Integer page, Integer size) {
        return PageHandler.build().handle(() -> PageHelper.startPage((int)page, (int)size).doSelectPage(() -> this.baseMapper().findsByColumn(this.clazz(), key, value)));
    }

    public Page<D> findPageByColumns(D domain, Integer page, Integer size) {
        return PageHandler.build().handle(() -> PageHelper.startPage((int)page, (int)size).doSelectPage(() -> this.baseMapper().findsByColumns(domain)));
    }

    public Page<D> findPageByCriteria(F form, Integer page, Integer size) {
        return PageHandler.build().handle(() -> PageHelper.startPage((int)page, (int)size).doSelectPage(() -> this.baseMapper().findsByCriteria(this.clazz(), this.buildCriteria2(form))));
    }

    public Page<Map> findPageByColumnsTableCriteria(String columns, String table, F form, Integer page, Integer size) {
        return PageHandler.build().handle(() -> PageHelper.startPage((int)page, (int)size).doSelectPage(() -> this.baseMapper().findsByColumnsTableCriteria(columns, table, this.buildCriteria2(form))));
    }

    public Page<Map> findPageBySQLCriteria(String sql, F form, Integer page, Integer size) {
        return PageHandler.build().handle(() -> PageHelper.startPage((int)page, (int)size).doSelectPage(() -> this.baseMapper().findsBySQLCriteria(sql, this.buildCriteria2(form))));
    }

    public Page<Map> findPageBySQL(String sql, Integer page, Integer size) {
        return PageHandler.build().handle(() -> PageHelper.startPage((int)page, (int)size).doSelectPage(() -> this.baseMapper().findsBySQL(sql)));
    }

    private final CriteriaQuery buildCriteria2(F form) {
        Limitable limitable;
        String limit;
        Orderable orderable;
        String orderBy;
        Groupable groupable;
        String groupBy;
        CriteriaQuery query = this.buildCriteria(form);
        if (form instanceof Groupable && StringUtils.isNotBlank((CharSequence)(groupBy = (groupable = (Groupable)form).getGroupBy()))) {
            query.groupBy(groupBy);
        }
        if (form instanceof Orderable && StringUtils.isNotBlank((CharSequence)(orderBy = (orderable = (Orderable)form).getOrderBy()))) {
            query.orderBy(orderBy);
        }
        if (form instanceof Limitable && StringUtils.isNotBlank((CharSequence)(limit = (limitable = (Limitable)form).getLimit()))) {
            query.limit(limit);
        }
        if (!(form instanceof Idsable)) {
            return query;
        }
        Idsable idsable = (Idsable)form;
        List<Object> ids = idsable.getIds();
        if (CollectionUtils.isEmpty(ids)) {
            return query;
        }
        String primaryKey = TableUtils.getPrimaryKey(this.clazz());
        Class clazz = ClassUtils.getFieldType(this.clazz(), (String)primaryKey);
        if (String.class.equals((Object)clazz)) {
            query.and().where(" " + primaryKey + " in ('" + StringUtils.join(ids, (String)"','") + "') ");
        } else if (ClassUtils.isNumberType((Class)clazz)) {
            query.and().where(" " + primaryKey + " in (" + StringUtils.join(ids, (String)",") + ") ");
        }
        return query;
    }
}

