/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.orm.util;

import com.bruce.tool.common.util.ClassUtils;
import com.bruce.tool.mybatis.orm.util.DomainInfo;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class TableUtils {
    private static final Map<Class, DomainInfo> cache = new HashMap<Class, DomainInfo>();

    public static Field getPrimary(Class clazz) {
        return cache.computeIfAbsent(clazz, DomainInfo::new).getPrimary();
    }

    public static String getPrimaryKey(Class clazz) {
        return cache.computeIfAbsent(clazz, DomainInfo::new).getPrimaryKey();
    }

    public static String getTableName(Class clazz) {
        return cache.computeIfAbsent(clazz, DomainInfo::new).getTableName();
    }

    public static String getColumnMapping(Class clazz) {
        return cache.computeIfAbsent(clazz, DomainInfo::new).getColumnMapping();
    }

    public static Field[] getFields(Class<?> beanClass) {
        Object[] beanFields = beanClass.getDeclaredFields();
        Class<?> beanSuperClass = beanClass.getSuperclass();
        Object[] beanSuperFields = beanSuperClass.getDeclaredFields();
        return (Field[])ArrayUtils.addAll((Object[])beanFields, (Object[])beanSuperFields);
    }

    public static Field getField(Class clazz, String fieldName) {
        return cache.computeIfAbsent(clazz, DomainInfo::new).getField(fieldName);
    }

    public static List<Field> getFieldsWithValue(Object domain) {
        Class<?> clazz = domain.getClass();
        List<Field> fields = cache.computeIfAbsent(clazz, DomainInfo::new).getAllFields();
        ArrayList results = Lists.newArrayList();
        for (Field field : fields) {
            Object value = ClassUtils.getValue((Object)domain, (String)field.getName());
            if (!Objects.nonNull(value)) continue;
            results.add(field);
        }
        return results;
    }

    private TableUtils() {
    }
}

