/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.orm.util;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.mybatis.orm.annotation.Id;
import com.bruce.tool.mybatis.orm.constant.SQLCode;
import com.bruce.tool.mybatis.orm.util.ColumnUtils;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomainInfo {
    private Class<?> clazz;
    private String tableName;
    private String columnMapping;
    private Field[] fields;
    private Map<String, Field> fieldMap = new HashMap<String, Field>();
    private Field primary;
    private String primaryKey;

    public DomainInfo(Class clazz) {
        this.clazz = clazz;
        this.init();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnMapping() {
        return this.columnMapping;
    }

    public Field getPrimary() {
        if (null == this.primary) {
            throw new BaseRuntimeException((Object)SQLCode.FE005.getCode(), "\u6ca1\u6709\u4e3b\u952e@Id\u6807\u8bc6");
        }
        return this.primary;
    }

    public String getPrimaryKey() {
        if (null == this.primaryKey) {
            throw new BaseRuntimeException((Object)SQLCode.FE005.getCode(), "\u6ca1\u6709\u4e3b\u952e@Id\u6807\u8bc6");
        }
        return this.primaryKey;
    }

    public Field getField(String fieldName) {
        Field field = this.fieldMap.get(fieldName);
        if (null == field) {
            throw new BaseRuntimeException((Object)SQLCode.FE005.getCode(), fieldName + "\u4e0d\u5b58\u5728");
        }
        return field;
    }

    public List<Field> getAllFields() {
        return Lists.newArrayList((Object[])this.fields);
    }

    private void init() {
        this.tableName = ColumnUtils.fetchTableName(this.clazz);
        this.fields = this.clazz.getDeclaredFields();
        if (this.fields != null) {
            String AS = " AS ";
            String CONJ = ", ";
            StringBuilder sb = new StringBuilder();
            for (Field field : this.fields) {
                if (ColumnUtils.needIgnore(field)) continue;
                String columnName = ColumnUtils.fetchColumnName(field);
                this.setPrimaryKey(field, columnName);
                this.fieldMap.put(field.getName(), field);
                String fieldName = ColumnUtils.fetchColumnName(field.getName());
                sb.append(columnName).append(" AS ").append(fieldName);
                sb.append(", ");
            }
            this.columnMapping = sb.substring(0, sb.lastIndexOf(", "));
        }
    }

    private void setPrimaryKey(Field field, String fieldName) {
        Id id = field.getAnnotation(Id.class);
        if (null == id) {
            return;
        }
        if (null != this.primaryKey) {
            throw new BaseRuntimeException((Object)SQLCode.FE005.getCode(), "Class\u5b58\u57282\u4e2a\u62162\u4e2a\u4ee5\u4e0a@Id\u6807\u6ce8\u4e3b\u952e");
        }
        this.primary = field;
        this.primaryKey = fieldName;
    }
}

