/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.orm.util;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.exception.ExceptionUtils;
import com.bruce.tool.mybatis.orm.annotation.Column;
import com.bruce.tool.mybatis.orm.annotation.Id;
import com.bruce.tool.mybatis.orm.annotation.Table;
import com.bruce.tool.mybatis.orm.annotation.Transient;
import com.bruce.tool.mybatis.orm.constant.SQLCode;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class ColumnUtils {
    private static final String[] keywords = new String[]{"add", "all", "alter", "analyze", "and", "as", "asc", "asensitive", "before", "between", "bigint", "binary", "blob", "both", "by", "call", "cascade", "case", "change", "char", "character", "check", "collate", "column", "condition", "connection", "constraint", "continue", "convert", "create", "cross", "current_date", "current_time", "current_timestamp", "current_user", "cursor", "database", "databases", "day_hour", "day_microsecond", "day_minute", "day_second", "dec", "decimal", "declare", "default", "delayed", "delete", "desc", "describe", "deterministic", "distinct", "distinctrow", "div", "double", "drop", "dual", "each", "else", "elseif", "enclosed", "escaped", "exists", "exit", "explain", "false", "fetch", "float", "float4", "float8", "for", "force", "foreign", "from", "fulltext", "goto", "grant", "group", "having", "high_priority", "hour_microsecond", "hour_minute", "hour_second", "if", "ignore", "in", "index", "infile", "inner", "inout", "insensitive", "insert", "int", "int1", "int2", "int3", "int4", "int8", "integer", "interval", "into", "is", "iterate", "join", "key", "keys", "kill", "label", "leading", "leave", "left", "like", "limit", "linear", "lines", "load", "localtime", "localtimestamp", "lock", "long", "longblob", "longtext", "loop", "low_priority", "match", "mediumblob", "mediumint", "mediumtext", "middleint", "minute_microsecond", "minute_second", "mod", "modifies", "natural", "not", "no_write_to_binlog", "null", "numeric", "on", "optimize", "option", "optionally", "or", "order", "out", "outer", "outfile", "precision", "primary", "procedure", "purge", "raid0", "range", "read", "reads", "real", "references", "regexp", "release", "rename", "repeat", "replace", "require", "restrict", "return", "revoke", "right", "rlike", "schema", "schemas", "second_microsecond", "select", "sensitive", "separator", "set", "show", "smallint", "spatial", "specific", "sql", "sqlexception", "sqlstate", "sqlwarning", "sql_big_result", "sql_calc_found_rows", "sql_small_result", "ssl", "starting", "straight_join", "table", "terminated", "then", "tinyblob", "tinyint", "tinytext", "to", "trailing", "trigger", "true", "undo", "union", "unique", "unlock", "unsigned", "update", "usage", "use", "using", "utc_date", "utc_time", "utc_timestamp", "values", "varbinary", "varchar", "varcharacter", "varying", "when", "where", "while", "with", "write", "x509", "xor", "year_month", "zerofill"};
    private static final List<String> keywordlist = new ArrayList<String>();
    private static final String QUOTATION_MARKS = "`";
    private static final Set<Class> allowDataClassType;

    public static String fetchTableName(Class<?> clazz) {
        String tableName = ColumnUtils.fetchTableNameFromAnnotation(clazz);
        if (StringUtils.isEmpty((Object)tableName)) {
            tableName = ColumnUtils.humpToUnderline(clazz.getSimpleName());
        }
        return tableName;
    }

    public static String fetchTableNameFromAnnotation(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        String tableName = "";
        if (null != table) {
            tableName = table.value();
        }
        return tableName;
    }

    public static String fetchColumnName(Field field) {
        String columnName = ColumnUtils.fetchColumnNameFromAnnotation(field);
        if (StringUtils.isEmpty((Object)columnName)) {
            columnName = ColumnUtils.humpToUnderline(field.getName());
        }
        return ColumnUtils.fetchColumnName(columnName);
    }

    public static String fetchColumnName(String columnName) {
        if (keywordlist.contains(columnName.toLowerCase())) {
            columnName = QUOTATION_MARKS + columnName + QUOTATION_MARKS;
        }
        return columnName;
    }

    public static String fetchColumnNameFromAnnotation(Field field) {
        Id id = field.getAnnotation(Id.class);
        String columnName = "";
        if (null != id) {
            columnName = id.value();
        }
        if (!StringUtils.isEmpty((Object)columnName)) {
            return columnName;
        }
        Column column = field.getAnnotation(Column.class);
        if (null != column) {
            columnName = column.value();
        }
        return columnName;
    }

    public static String humpToUnderline(String humpString) {
        if (humpString == null || humpString.isEmpty()) {
            return "";
        }
        String prefix = "";
        if (humpString.charAt(0) == '_') {
            humpString = humpString.substring(1, humpString.length());
            prefix = "_";
        }
        String regexStr = "[A-Z0-9]";
        Matcher matcher = Pattern.compile(regexStr).matcher(humpString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String g = matcher.group();
            matcher.appendReplacement(sb, "_" + g.toLowerCase());
        }
        matcher.appendTail(sb);
        if (sb.charAt(0) == '_') {
            sb.delete(0, 1);
        }
        sb.insert(0, prefix);
        return sb.toString();
    }

    public static boolean isPrimaryKey(Field field) {
        Id id = field.getAnnotation(Id.class);
        return Objects.nonNull(id);
    }

    public static boolean needIgnore(Field field) {
        return Objects.nonNull(field.getAnnotation(Transient.class));
    }

    public static <T> boolean fieldHasValue(T obj, Field field) {
        Object value;
        if (!ColumnUtils.isAllowClassType(field)) {
            throw new BaseRuntimeException((Object)SQLCode.FE005.getCode(), "\u4e0d\u5141\u8bb8\u7684\u5b57\u6bb5\u7c7b\u578b");
        }
        try {
            field.setAccessible(true);
            value = field.get(obj);
        }
        catch (IllegalAccessException e) {
            ExceptionUtils.printStackTrace((Throwable)e);
            throw new BaseRuntimeException((Object)SQLCode.FE005.getCode(), "\u83b7\u53d6\u5b57\u6bb5\u503c\u9519\u8bef");
        }
        return Objects.nonNull(value);
    }

    private static boolean isAllowClassType(Field field) {
        return allowDataClassType.contains(field.getType());
    }

    private ColumnUtils() {
    }

    static {
        keywordlist.addAll(Arrays.asList(keywords));
        allowDataClassType = new HashSet<Class>();
        allowDataClassType.add(Byte.class);
        allowDataClassType.add(Short.class);
        allowDataClassType.add(Integer.class);
        allowDataClassType.add(Long.class);
        allowDataClassType.add(Character.class);
        allowDataClassType.add(Float.class);
        allowDataClassType.add(Double.class);
        allowDataClassType.add(String.class);
        allowDataClassType.add(BigDecimal.class);
    }
}

