/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.orm.provider;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.util.ClassUtils;
import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.mybatis.orm.builder.BatchUpdateSQLBuilder;
import com.bruce.tool.mybatis.orm.constant.SQLCode;
import com.bruce.tool.mybatis.orm.util.ColumnUtils;
import com.bruce.tool.mybatis.orm.util.TableUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class UpdateProvider {
    public String update(Object domain) {
        return this.update(domain, true);
    }

    public String updateBySelective(Object domain) {
        return this.update(domain, false);
    }

    public String updateAll(Map<String, Object> params) {
        List list = (List)params.get("list");
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Object item = list.get(0);
        Class<?> clazz = item.getClass();
        String tableName = TableUtils.getTableName(clazz);
        String primaryKey = TableUtils.getPrimaryKey(clazz);
        BatchUpdateSQLBuilder<List> builder = new BatchUpdateSQLBuilder<List>();
        builder.setUpdateTable(tableName, primaryKey);
        builder.setData(list);
        return builder.toString();
    }

    public String updateBySQL(Map<String, Object> params) {
        String sql = (String)params.get("sql");
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new BaseRuntimeException((Object)SQLCode.FE004.getCode(), "\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u5b57\u6bb5\u548c\u8868\u62fc\u63a5\u4e3a\u7a7a");
        }
        return sql;
    }

    private String update(Object domain, boolean saveNull) {
        Class<?> beanClass = domain.getClass();
        String tableName = TableUtils.getTableName(beanClass);
        List fields = ClassUtils.getAllFields(beanClass);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("UPDATE ").append(tableName).append(" set ");
        try {
            Field primaryKey = null;
            String primaryColumn = null;
            int length = fields.size();
            for (int i = 0; i < length; ++i) {
                Field field = (Field)fields.get(i);
                if (ColumnUtils.needIgnore(field)) continue;
                String columnName = ColumnUtils.fetchColumnName(field);
                if (ColumnUtils.isPrimaryKey(field)) {
                    primaryKey = field;
                    primaryColumn = columnName;
                    continue;
                }
                field.setAccessible(true);
                Object object = field.get(domain);
                if (Objects.nonNull(object)) {
                    updateSql.append(columnName).append("=").append("#{" + field.getName() + "}").append(",");
                    continue;
                }
                if (!saveNull) continue;
                updateSql.append(columnName).append("=").append("#{" + field.getName() + "}").append(",");
            }
            if (updateSql.toString().endsWith(",")) {
                updateSql = updateSql.replace(updateSql.length() - 1, updateSql.length(), "");
            }
            if (Objects.isNull(primaryKey)) {
                throw new BaseRuntimeException((Object)SQLCode.FE004.getCode(), "\u8981\u66f4\u65b0\u7684\u8868,\u7f3a\u5c11\u4e3b\u952e,\u65e0\u6cd5\u901a\u8fc7\u6b64\u65b9\u6cd5\u5b8c\u6210\u6570\u636e\u66f4\u65b0");
            }
            updateSql.append(" where ").append(primaryColumn).append("=").append("#{" + primaryKey.getName() + "}");
        }
        catch (Exception e) {
            throw new BaseRuntimeException((Object)SQLCode.FE004.getCode(), "get update sql is exceptoin:" + e);
        }
        return updateSql.toString();
    }
}

