/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.orm.provider;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.util.ClassUtils;
import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.mybatis.orm.builder.BatchInsertSQLBuilder;
import com.bruce.tool.mybatis.orm.constant.SQLCode;
import com.bruce.tool.mybatis.orm.util.ColumnUtils;
import com.bruce.tool.mybatis.orm.util.TableUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class SaveProvider {
    public String save(Object bean) {
        int i;
        Class<?> beanClass = bean.getClass();
        String tableName = TableUtils.getTableName(beanClass);
        List fields = ClassUtils.getAllFields(beanClass);
        StringBuilder insertSql = new StringBuilder();
        ArrayList<String> insertParams = new ArrayList<String>();
        ArrayList<String> insertParamNames = new ArrayList<String>();
        insertSql.append("insert into ").append(tableName).append("(");
        try {
            for (i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                if (ColumnUtils.needIgnore(field)) continue;
                String columnName = ColumnUtils.fetchColumnName(field);
                field.setAccessible(true);
                Object object = field.get(bean);
                if (object == null) continue;
                insertParamNames.add(columnName);
                insertParams.add("#{" + field.getName() + "}");
            }
        }
        catch (Exception e) {
            throw new BaseRuntimeException((Object)SQLCode.FE004.getCode(), "\u63d2\u5165\u8bed\u53e5\u8bbe\u7f6e\u5f02\u5e38:" + e.getMessage());
        }
        for (i = 0; i < insertParamNames.size(); ++i) {
            insertSql.append((String)insertParamNames.get(i));
            if (i == insertParamNames.size() - 1) continue;
            insertSql.append(",");
        }
        insertSql.append(")").append(" values(");
        for (i = 0; i < insertParams.size(); ++i) {
            insertSql.append((String)insertParams.get(i));
            if (i == insertParams.size() - 1) continue;
            insertSql.append(",");
        }
        insertSql.append(")");
        return insertSql.toString();
    }

    public String saveAll(Map<String, Object> params) {
        List list = (List)params.get("list");
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        Object item = list.get(0);
        Class<?> clazz = item.getClass();
        String tableName = TableUtils.getTableName(clazz);
        BatchInsertSQLBuilder builder = new BatchInsertSQLBuilder();
        builder.setInsertTable(tableName);
        builder.setSelective(false);
        builder.setData(list);
        return builder.toString();
    }

    public String saveBySQL(Map<String, Object> params) {
        String sql = (String)params.get("sql");
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new BaseRuntimeException((Object)SQLCode.FE004.getCode(), "\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u5b57\u6bb5\u548c\u8868\u62fc\u63a5\u4e3a\u7a7a");
        }
        return sql;
    }
}

