/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.orm.provider;

import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.mybatis.orm.exception.OrmNullException;
import com.bruce.tool.mybatis.orm.query.CriteriaQuery;
import com.bruce.tool.mybatis.orm.util.ColumnUtils;
import com.bruce.tool.mybatis.orm.util.TableUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.jdbc.SQL;
import org.springframework.util.CollectionUtils;

public class FindProvider {
    private static final String ID_PLACEHOLDER = " = #{id}";
    public static final String BEGIN_PLACEHOLDER = " = #{";
    public static final String END_PLACEHOLDER = "}";

    public String findByDomainId(Object domain) {
        Class<?> clazz = domain.getClass();
        if (Objects.isNull(clazz)) {
            throw new OrmNullException();
        }
        String tableName = TableUtils.getTableName(clazz);
        String columnMapping = TableUtils.getColumnMapping(clazz);
        String primary = TableUtils.getPrimaryKey(clazz);
        if (StringUtils.isBlank((CharSequence)primary)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u5f53\u524d\u8868\u65e0\u4e3b\u952e,\u4e0d\u80fd\u4f7f\u7528findById(domain)\u65b9\u6cd5\u67e5\u8be2");
        }
        SQL sql = new SQL();
        sql.SELECT(columnMapping);
        sql.FROM(tableName);
        ((SQL)sql.AND()).WHERE(primary + BEGIN_PLACEHOLDER + primary + END_PLACEHOLDER);
        return sql.toString();
    }

    public String findById(Map<String, Object> params) {
        Class<?> clazz = this.getParamClass(params);
        if (Objects.isNull(clazz)) {
            throw new OrmNullException();
        }
        String tableName = TableUtils.getTableName(clazz);
        String columnMapping = TableUtils.getColumnMapping(clazz);
        String primary = TableUtils.getPrimaryKey(clazz);
        if (StringUtils.isBlank((CharSequence)primary)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u5f53\u524d\u8868\u65e0\u4e3b\u952e,\u4e0d\u80fd\u4f7f\u7528findById(domain)\u65b9\u6cd5\u67e5\u8be2");
        }
        SQL sql = new SQL();
        sql.SELECT(columnMapping);
        sql.FROM(tableName);
        ((SQL)sql.AND()).WHERE(primary + ID_PLACEHOLDER);
        return sql.toString();
    }

    public String findByColumn(Map<String, Object> params) {
        Class<?> clazz = this.getParamClass(params);
        if (Objects.isNull(clazz)) {
            throw new OrmNullException();
        }
        String tableName = TableUtils.getTableName(clazz);
        String columnMapping = TableUtils.getColumnMapping(clazz);
        String column = (String)params.get("column");
        if (StringUtils.isBlank((CharSequence)column)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u952e\u503c\u4e3a\u7a7a");
        }
        SQL sql = new SQL();
        sql.SELECT(columnMapping);
        sql.FROM(tableName);
        ((SQL)sql.AND()).WHERE(ColumnUtils.fetchColumnName(column) + BEGIN_PLACEHOLDER + "value" + END_PLACEHOLDER);
        return sql.toString();
    }

    public String findByColumns(Object domain) {
        if (Objects.isNull(domain)) {
            throw new OrmNullException();
        }
        Class<?> clazz = domain.getClass();
        String tableName = TableUtils.getTableName(clazz);
        String columnMapping = TableUtils.getColumnMapping(clazz);
        List<Field> fields = TableUtils.getFieldsWithValue(domain);
        if (CollectionUtils.isEmpty(fields)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u5bf9\u8c61\u7684\u6240\u6709\u5b57\u6bb5\u90fd\u6ca1\u6709\u503c,\u65e0\u6cd5\u5b8c\u6210\u67e5\u8be2");
        }
        SQL sql = new SQL();
        sql.SELECT(columnMapping);
        sql.FROM(tableName);
        for (Field field : fields) {
            ((SQL)sql.AND()).WHERE(ColumnUtils.fetchColumnName(field) + BEGIN_PLACEHOLDER + field.getName() + END_PLACEHOLDER);
        }
        return sql.toString();
    }

    public String findByColumnsTableCriteria(Map<String, Object> params) {
        String columns = (String)params.get("columns");
        if (StringUtils.isBlank((CharSequence)columns)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u5b57\u6bb5\u4e3a\u7a7a,\u7ec8\u6b62\u67e5\u8be2");
        }
        String table = (String)params.get("table");
        if (StringUtils.isBlank((CharSequence)table)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u8868\u660e\u4e3a\u7a7a,\u7ec8\u6b62\u67e5\u8be2");
        }
        CriteriaQuery criteria = this.getCriteriaQuery(params);
        SQL sql = new SQL();
        sql.SELECT(columns);
        sql.FROM(table);
        this.appendConditions(criteria, sql);
        return sql.toString();
    }

    public String findsByCriteria(Map<String, Object> params) {
        Class<?> clazz = this.getParamClass(params);
        if (Objects.isNull(clazz)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u7c7b\u4e3a\u7a7a,\u7ec8\u6b62\u67e5\u8be2");
        }
        CriteriaQuery criteria = this.getCriteriaQuery(params);
        String tableName = TableUtils.getTableName(clazz);
        String columnMapping = TableUtils.getColumnMapping(clazz);
        SQL sql = new SQL();
        sql.SELECT(columnMapping);
        sql.FROM(tableName);
        this.appendConditions(criteria, sql);
        return sql.toString();
    }

    public String findsByColumnsTableCriteria(Map<String, Object> params) {
        return this.findByColumnsTableCriteria(params);
    }

    public String findBySQLCriteria(Map<String, Object> params) {
        StringBuilder sql = new StringBuilder((String)params.get("sql"));
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u5b57\u6bb5\u548c\u8868\u62fc\u63a5\u4e3a\u7a7a");
        }
        sql.append(" where true ");
        CriteriaQuery criteria = this.getCriteriaQuery(params);
        for (String bsql : criteria.getAnds()) {
            sql.append(" and (" + bsql + ")");
        }
        for (String bsql : criteria.getOrs()) {
            sql.append(" or (" + bsql + ")");
        }
        for (String bsql : criteria.getOrderBys()) {
            sql.append(" order by " + bsql);
        }
        for (String bsql : criteria.getGroupBys()) {
            sql.append(" group by " + bsql);
        }
        return sql.toString();
    }

    public String findBySQL(Map<String, Object> params) {
        String sql = (String)params.get("sql");
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u5b57\u6bb5\u548c\u8868\u62fc\u63a5\u4e3a\u7a7a");
        }
        return sql;
    }

    private void appendConditions(CriteriaQuery criteria, SQL sql) {
        for (String sqls : criteria.getAnds()) {
            ((SQL)sql.AND()).WHERE(sqls);
        }
        for (String sqls : criteria.getOrs()) {
            ((SQL)sql.OR()).WHERE(sqls);
        }
        for (String sqls : criteria.getOrderBys()) {
            sql.ORDER_BY(sqls);
        }
        for (String sqls : criteria.getGroupBys()) {
            sql.GROUP_BY(sqls);
        }
    }

    private Class<?> getParamClass(Map<String, Object> params) {
        return (Class)params.get("clazz");
    }

    private CriteriaQuery getCriteriaQuery(Map<String, Object> params) {
        CriteriaQuery criteria = (CriteriaQuery)params.get("criteria");
        if (Objects.isNull(criteria)) {
            throw new OrmNullException("\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u6761\u4ef6\u5bf9\u8c61\u4e3a\u7a7a,\u7ec8\u6b62\u67e5\u8be2");
        }
        return criteria;
    }
}

