/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.orm.provider;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.mybatis.orm.constant.SQLCode;
import com.bruce.tool.mybatis.orm.util.ColumnUtils;
import com.bruce.tool.mybatis.orm.util.TableUtils;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.springframework.util.CollectionUtils;

public class DeleteProvider {
    private static final String ID_PLACEHOLDER = " = #{id}";
    public static final String BEGIN_PLACEHOLDER = " = #{";
    public static final String END_PLACEHOLDER = "}";

    public String deleteByDomainId(Object domain) {
        Class<?> clazz = domain.getClass();
        if (Objects.isNull(clazz)) {
            throw new BaseRuntimeException((Object)SQLCode.FE004.getCode(), "\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u7c7b\u4e3a\u7a7a");
        }
        String tableName = TableUtils.getTableName(clazz);
        String primary = TableUtils.getPrimaryKey(clazz);
        if (com.bruce.tool.common.util.string.StringUtils.isBlank((CharSequence)primary)) {
            throw new BaseRuntimeException((Object)SQLCode.FE001.getCode(), "\u67e5\u8be2\u5f02\u5e38:\u5f53\u524d\u8868\u65e0\u4e3b\u952e,\u4e0d\u80fd\u4f7f\u7528findById(domain)\u65b9\u6cd5\u67e5\u8be2");
        }
        SQL sql = new SQL();
        sql.DELETE_FROM(tableName);
        ((SQL)sql.AND()).WHERE(primary + BEGIN_PLACEHOLDER + primary + END_PLACEHOLDER);
        return sql.toString();
    }

    public String deleteById(Map<String, Object> params) {
        Class clazz = this.getParamClass(params);
        String tableName = TableUtils.getTableName(clazz);
        String id = TableUtils.getPrimaryKey(clazz);
        SQL sql = new SQL();
        sql.DELETE_FROM(tableName);
        sql.WHERE(id + ID_PLACEHOLDER);
        return sql.toString();
    }

    public String deleteByColumn(Map<String, Object> params) {
        Class clazz = this.getParamClass(params);
        String column = (String)params.get("column");
        String tableName = TableUtils.getTableName(clazz);
        SQL sql = new SQL();
        sql.DELETE_FROM(tableName);
        sql.WHERE(column + BEGIN_PLACEHOLDER + "value" + END_PLACEHOLDER);
        return sql.toString();
    }

    public String deleteByColumns(Object domain) {
        if (Objects.isNull(domain)) {
            throw new BaseRuntimeException((Object)SQLCode.FE004.getCode(), "\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u5bf9\u8c61\u4e3a\u7a7a,\u7ec8\u6b62\u67e5\u8be2");
        }
        Class<?> clazz = domain.getClass();
        String tableName = TableUtils.getTableName(clazz);
        List<Field> fields = TableUtils.getFieldsWithValue(domain);
        if (CollectionUtils.isEmpty(fields)) {
            throw new BaseRuntimeException((Object)SQLCode.FE003.getCode(), "\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u5bf9\u8c61\u7684\u6240\u6709\u5b57\u6bb5\u90fd\u6ca1\u6709\u503c,\u65e0\u6cd5\u5b8c\u6210\u67e5\u8be2");
        }
        SQL sql = new SQL();
        sql.DELETE_FROM(tableName);
        for (Field field : fields) {
            ((SQL)sql.AND()).WHERE(ColumnUtils.fetchColumnName(field) + BEGIN_PLACEHOLDER + field.getName() + END_PLACEHOLDER);
        }
        return sql.toString();
    }

    public String deleteBySQL(Map<String, Object> params) {
        String sql = (String)params.get("sql");
        if (com.bruce.tool.common.util.string.StringUtils.isBlank((CharSequence)sql)) {
            throw new BaseRuntimeException((Object)SQLCode.FE004.getCode(), "\u67e5\u8be2\u5f02\u5e38:\u4f20\u5165\u5b57\u6bb5\u548c\u8868\u62fc\u63a5\u4e3a\u7a7a");
        }
        return sql;
    }

    public String markDeleteById(Map<String, Object> params) {
        Class clazz = this.getParamClass(params);
        String tableName = TableUtils.getTableName(clazz);
        String id = TableUtils.getPrimaryKey(clazz);
        SQL sql = new SQL();
        sql.UPDATE(tableName);
        sql.SET("is_delete = " + new Date().getTime());
        sql.WHERE(id + ID_PLACEHOLDER);
        return sql.toString();
    }

    public String markDeleteByIdDiy(Map<String, Object> params) {
        Class clazz = this.getParamClass(params);
        String mark = (String)params.get("mark");
        if (StringUtils.isBlank((CharSequence)mark)) {
            throw new BaseRuntimeException((Object)SQLCode.FE004.getCode(), "\u6807\u8bb0\u5220\u9664\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String tableName = TableUtils.getTableName(clazz);
        String id = TableUtils.getPrimaryKey(clazz);
        SQL sql = new SQL();
        sql.UPDATE(tableName);
        sql.SET("is_delete = " + new Date().getTime());
        sql.WHERE(id + ID_PLACEHOLDER);
        return sql.toString();
    }

    private Class getParamClass(Map<String, Object> params) {
        return (Class)params.get("clazz");
    }
}

