/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.orm.builder;

import com.bruce.tool.mybatis.orm.util.ColumnUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class BatchUpdateSQLBuilder<T> {
    private String tableName;
    private String primaryKey;
    private Field primaryField;
    private String[] ignoreFields;
    private String[] updateFields;
    private LinkedList<Field> fields = new LinkedList();
    private boolean selective = true;
    private LinkedList<T> dataList = new LinkedList();
    private Set<Object> primaryValueList = new HashSet<Object>();
    private static final String QUOTE_OPEN = " (";
    private static final String QUOTE_CLOSE = ") ";
    private static final String UPDATE = "UPDATE ";
    private static final String SET = " SET ";
    private static final String EQUAL = " = ";
    private static final String WHEN = " WHEN ";
    private static final String CASE = " CASE ";
    private static final String THEN = " THEN ";
    private static final String ELSE = " ELSE ";
    private static final String END = " END ";
    private static final String WHERE = " WHERE ";
    private static final String IN = " IN ";
    private static final String COMMA = ",";
    private static final String QUOTATION_MARKS = "'";

    public BatchUpdateSQLBuilder setUpdateTable(String tableName, String primaryKey) {
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        return this;
    }

    public BatchUpdateSQLBuilder setSelective(boolean selective) {
        this.selective = selective;
        return this;
    }

    public BatchUpdateSQLBuilder setIgnoreFields(String ... ignoreFields) {
        this.ignoreFields = ignoreFields;
        return this;
    }

    public BatchUpdateSQLBuilder setUpdateFields(String ... updateFields) {
        this.updateFields = updateFields;
        return this;
    }

    public BatchUpdateSQLBuilder setData(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            throw new RuntimeException("\u5f85\u63d2\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        for (T t : list) {
            this.setData(t);
        }
        return this;
    }

    public BatchUpdateSQLBuilder setData(T obj) {
        Field[] declaredFields;
        if (!this.selective) {
            if (this.fields.size() == 0) {
                Field[] declaredFields2;
                for (Field field : declaredFields2 = obj.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    if (ColumnUtils.needIgnore(field)) continue;
                    String columnName = ColumnUtils.fetchColumnName(field);
                    if (columnName.equalsIgnoreCase(this.primaryKey)) {
                        this.primaryField = field;
                    }
                    this.fields.add(field);
                }
            }
            try {
                this.primaryValueList.add(this.primaryField.get(obj));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            this.dataList.add(obj);
            return this;
        }
        for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
            String columnName;
            field.setAccessible(true);
            if (ColumnUtils.needIgnore(field)) continue;
            if (this.primaryField == null && (columnName = ColumnUtils.fetchColumnName(field)).equalsIgnoreCase(this.primaryKey)) {
                this.primaryField = field;
            }
            if (!ColumnUtils.fieldHasValue(obj, field) || this.fields.contains(field)) continue;
            this.fields.add(field);
        }
        try {
            this.primaryValueList.add(this.primaryField.get(obj));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.dataList.add(obj);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.paramCheck();
        try {
            sb.append(UPDATE).append(this.tableName).append(SET);
            for (Field field : this.fields) {
                if (ColumnUtils.needIgnore(field)) continue;
                field.setAccessible(true);
                sb.append(this.getFieldString(field));
                sb.append(COMMA);
            }
            sb.replace(sb.lastIndexOf(COMMA), sb.lastIndexOf(COMMA) + 1, "");
            sb.append(this.getWhereString());
        }
        catch (IllegalAccessError e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String getFieldString(Field field) throws IllegalAccessException {
        StringBuilder sb = new StringBuilder();
        String fieldString = ColumnUtils.fetchColumnName(field);
        sb.append(fieldString).append(EQUAL).append(CASE);
        for (Object obj : this.dataList) {
            String primaryString = ColumnUtils.fetchColumnName(this.primaryField);
            sb.append(WHEN);
            sb.append(QUOTE_OPEN).append(primaryString).append(EQUAL);
            Object primary = this.primaryField.get(obj);
            if (primary == null) {
                throw new NullPointerException("\u66f4\u65b0\u4e3b\u952e\u503c\u4e3a\u7a7a");
            }
            if (primary instanceof String || primary instanceof Character) {
                primary = primary.toString().replaceAll("\\\\", "");
                primary = primary.toString().replaceAll(QUOTATION_MARKS, "\\\\'");
                primary = primary.toString().replaceAll("\"", "\\\\\"");
                sb.append(QUOTATION_MARKS).append(primary).append(QUOTATION_MARKS);
            } else {
                sb.append(primary);
            }
            sb.append(QUOTE_CLOSE);
            sb.append(THEN);
            Object value = field.get(obj);
            if (value == null) {
                if (this.selective) {
                    sb.append(fieldString);
                    continue;
                }
                sb.append(value);
                continue;
            }
            if (value instanceof String || value instanceof Character) {
                value = value.toString().replaceAll("\\\\", "");
                value = value.toString().replaceAll(QUOTATION_MARKS, "\\\\'");
                value = value.toString().replaceAll("\"", "\\\\\"");
                sb.append(QUOTATION_MARKS).append(value).append(QUOTATION_MARKS);
                continue;
            }
            sb.append(value);
        }
        sb.append(END);
        return sb.toString();
    }

    private String getWhereString() {
        StringBuilder sb = new StringBuilder();
        String primaryString = ColumnUtils.fetchColumnName(this.primaryField);
        sb.append(WHERE).append(primaryString).append(IN).append(QUOTE_OPEN);
        for (Object value : this.primaryValueList) {
            if (value instanceof String || value instanceof Character) {
                value = value.toString().replaceAll("\\\\", "");
                value = value.toString().replaceAll(QUOTATION_MARKS, "\\\\'");
                value = value.toString().replaceAll("\"", "\\\\\"");
                sb.append(QUOTATION_MARKS).append(value).append(QUOTATION_MARKS);
            } else {
                sb.append(value);
            }
            sb.append(COMMA);
        }
        sb.replace(sb.lastIndexOf(COMMA), sb.lastIndexOf(COMMA) + 1, "");
        sb.append(QUOTE_CLOSE);
        return sb.toString();
    }

    private void paramCheck() {
        String columnName;
        Field field;
        int i;
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new RuntimeException("\u63d2\u5165\u8868\u540d\u4e3a\u7a7a");
        }
        if (this.dataList.isEmpty()) {
            throw new RuntimeException("\u5f85\u63d2\u5165\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        if (this.fields.size() == 0) {
            throw new RuntimeException("\u5f85\u63d2\u5165\u5b57\u6bb5\u4e3a\u7a7a");
        }
        if (null != this.updateFields && this.updateFields.length > 0) {
            HashSet<String> updates = new HashSet<String>();
            updates.addAll(Arrays.asList(this.updateFields));
            for (i = 0; i < this.fields.size(); ++i) {
                field = this.fields.get(i);
                columnName = ColumnUtils.fetchColumnName(field);
                if (updates.contains(columnName)) continue;
                this.fields.remove(field);
                --i;
            }
        }
        if (this.ignoreFields != null && this.ignoreFields.length > 0) {
            HashSet<String> ignores = new HashSet<String>();
            ignores.addAll(Arrays.asList(this.ignoreFields));
            for (i = 0; i < this.fields.size(); ++i) {
                field = this.fields.get(i);
                columnName = ColumnUtils.fetchColumnName(field);
                if (!ignores.contains(columnName)) continue;
                this.fields.remove(field);
                --i;
            }
        }
    }
}

