/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.orm.builder;

import com.bruce.tool.mybatis.orm.util.ColumnUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import org.springframework.util.StringUtils;

public class BatchInsertSQLBuilder<T> {
    private String tableName;
    private Field[] fields = new Field[0];
    private LinkedList<T> dataList = new LinkedList();
    private boolean selective = true;
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String VALUES = "VALUES";
    private static final String QUOTE_OPEN = " (";
    private static final String QUOTE_CLOSE = ") ";
    private static final String COMMA = ",";
    private static final String QUOTATION_MARKS = "'";
    private static final String QUOTATION_MARKS_OPEN = "`";
    private static final String QUOTATION_MARKS_CLOSE = "`";

    public BatchInsertSQLBuilder() {
    }

    public BatchInsertSQLBuilder(String tableName, LinkedList<T> dataList, boolean selective) {
        this.setInsertTable(tableName);
        this.setData((Collection<T>)dataList);
        this.setSelective(selective);
    }

    public BatchInsertSQLBuilder setInsertTable(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public BatchInsertSQLBuilder setSelective(boolean selective) {
        this.selective = selective;
        return this;
    }

    public BatchInsertSQLBuilder setData(T obj) {
        if (!this.selective) {
            if (this.fields.length == 0) {
                Field[] declaredFields;
                LinkedList<Field> fieldList = new LinkedList<Field>();
                for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    if (ColumnUtils.needIgnore(field)) continue;
                    fieldList.add(field);
                }
                this.fields = fieldList.toArray(this.fields);
            }
            this.dataList.add(obj);
            return this;
        }
        if (this.fields.length == 0) {
            Field[] declaredFields = obj.getClass().getDeclaredFields();
            LinkedList<Field> fieldList = new LinkedList<Field>();
            for (Field field : declaredFields) {
                if ("serialVersionUID".equalsIgnoreCase(field.getName())) continue;
                field.setAccessible(true);
                if (ColumnUtils.needIgnore(field) || !ColumnUtils.fieldHasValue(obj, field)) continue;
                fieldList.add(field);
            }
            this.fields = fieldList.toArray(this.fields);
        }
        this.dataList.add(obj);
        return this;
    }

    public BatchInsertSQLBuilder setData(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            throw new RuntimeException("\u5f85\u63d2\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        for (T t : list) {
            this.setData(t);
        }
        return this;
    }

    public String toString() {
        this.paramCheck();
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(INSERT_INTO).append(this.tableName);
            sb.append(this.getFieldString());
            sb.append(VALUES);
            for (Object t : this.dataList) {
                sb.append(this.getValueString(t));
                sb.append(COMMA);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return sb.substring(0, sb.length() - 1);
    }

    private String getFieldString() {
        StringBuilder sb = new StringBuilder();
        sb.append(QUOTE_OPEN);
        for (Field field : this.fields) {
            String columnName;
            field.setAccessible(true);
            if (ColumnUtils.needIgnore(field) || StringUtils.isEmpty((Object)(columnName = ColumnUtils.fetchColumnName(field)))) continue;
            sb.append(columnName);
            sb.append(COMMA);
        }
        if (sb.toString().endsWith(COMMA)) {
            sb.replace(sb.length() - 1, sb.length(), "");
        }
        sb.append(QUOTE_CLOSE);
        return sb.toString();
    }

    private String getValueString(T t) throws IllegalAccessException {
        StringBuilder sb = new StringBuilder();
        sb.append(QUOTE_OPEN);
        for (Field field : this.fields) {
            field.setAccessible(true);
            Object value = field.get(t);
            if (value != null) {
                sb.append(QUOTATION_MARKS);
                value = value.toString().replaceAll("\\\\", "");
                value = value.toString().replaceAll(QUOTATION_MARKS, "\\\\'");
                value = value.toString().replaceAll("\"", "\\\\\"");
                sb.append(value);
                sb.append(QUOTATION_MARKS);
            } else {
                sb.append(value);
            }
            sb.append(COMMA);
        }
        sb.replace(sb.lastIndexOf(COMMA), sb.lastIndexOf(COMMA) + 1, "");
        sb.append(QUOTE_CLOSE);
        return sb.toString();
    }

    private void paramCheck() {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new RuntimeException("\u63d2\u5165\u8868\u540d\u4e3a\u7a7a");
        }
        if (this.dataList.isEmpty()) {
            throw new RuntimeException("\u5f85\u63d2\u5165\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        if (this.fields.length == 0) {
            throw new RuntimeException("\u5f85\u63d2\u5165\u5b57\u6bb5\u4e3a\u7a7a");
        }
    }
}

