/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.generator.plugin;

import com.bruce.tool.common.util.string.StringUtils;
import java.util.List;
import java.util.Objects;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.ShellRunner;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class TableDomainAndDaoPlugin
extends PluginAdapter {
    private static final String CREATE_XML_MAPPER = "createXmlMapper";
    private static final String PRIMARY_KEY_SUFFIX = "PrimaryKey";
    private static final String PRIMARY_KEY_PLACE = "Id";
    private static final String EXAMPLE_KEY_SUFFIX = "Example";
    private static final String EXAMPLE_KEY_PLACE = "Params";
    private String suffix;

    public void initialized(IntrospectedTable introspectedTable) {
        String old = introspectedTable.getMyBatis3JavaMapperType();
        old = this.replaceSuffix(old, "Mapper", this.suffix);
        introspectedTable.setMyBatis3JavaMapperType(old);
        old = introspectedTable.getMyBatis3XmlMapperFileName();
        old = this.replaceSuffix(old, "Mapper", this.suffix);
        introspectedTable.setMyBatis3XmlMapperFileName(old);
        old = introspectedTable.getSelectByPrimaryKeyStatementId();
        old = this.replaceSuffix(old, "selectByPrimaryKey", "findOne");
        introspectedTable.setSelectByPrimaryKeyStatementId(old);
        old = introspectedTable.getUpdateByPrimaryKeyWithBLOBsStatementId();
        old = this.replaceSuffix(old, "updateByPrimaryKeyWithBLOBs", "updateByIdWithBLOBs");
        introspectedTable.setUpdateByPrimaryKeyWithBLOBsStatementId(old);
        old = introspectedTable.getUpdateByPrimaryKeyStatementId();
        old = this.replaceSuffix(old, PRIMARY_KEY_SUFFIX, PRIMARY_KEY_PLACE);
        introspectedTable.setUpdateByPrimaryKeyStatementId(old);
        old = introspectedTable.getDeleteByPrimaryKeyStatementId();
        old = this.replaceSuffix(old, PRIMARY_KEY_SUFFIX, PRIMARY_KEY_PLACE);
        introspectedTable.setDeleteByPrimaryKeyStatementId(old);
        old = introspectedTable.getSelectAllStatementId();
        old = this.replaceSuffix(old, PRIMARY_KEY_SUFFIX, PRIMARY_KEY_PLACE);
        introspectedTable.setSelectAllStatementId(old);
        old = introspectedTable.getUpdateByPrimaryKeySelectiveStatementId();
        old = this.replaceSuffix(old, PRIMARY_KEY_SUFFIX, PRIMARY_KEY_PLACE);
        introspectedTable.setUpdateByPrimaryKeySelectiveStatementId(old);
        old = introspectedTable.getSelectByExampleStatementId();
        old = this.replaceSuffix(old, EXAMPLE_KEY_SUFFIX, EXAMPLE_KEY_PLACE);
        introspectedTable.setSelectByExampleStatementId(old);
        old = introspectedTable.getUpdateByExampleStatementId();
        old = this.replaceSuffix(old, EXAMPLE_KEY_SUFFIX, EXAMPLE_KEY_PLACE);
        introspectedTable.setUpdateByExampleStatementId(old);
        old = introspectedTable.getDeleteByExampleStatementId();
        old = this.replaceSuffix(old, EXAMPLE_KEY_SUFFIX, EXAMPLE_KEY_PLACE);
        introspectedTable.setDeleteByExampleStatementId(old);
        old = introspectedTable.getUpdateByExampleSelectiveStatementId();
        old = this.replaceSuffix(old, EXAMPLE_KEY_SUFFIX, EXAMPLE_KEY_PLACE);
        introspectedTable.setUpdateByExampleSelectiveStatementId(old);
        super.initialized(introspectedTable);
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String classInfo;
        Object createDao = super.getProperties().get("createDao");
        if (Objects.isNull(createDao) || "false".equals(String.valueOf(createDao))) {
            return false;
        }
        Object createXmlMapper = super.getProperties().get(CREATE_XML_MAPPER);
        if (Objects.nonNull(createXmlMapper) && "true".equals(String.valueOf(createXmlMapper))) {
            return true;
        }
        Object interfaces = super.getProperties().get("interface");
        if (Objects.nonNull(interfaces) && interfaces instanceof String && StringUtils.isNotBlank((CharSequence)(classInfo = (String)interfaces))) {
            String interfaceName = classInfo;
            if (classInfo.contains(".")) {
                interfaceName = classInfo.substring(classInfo.lastIndexOf(46) + 1, classInfo.length());
            }
            if (StringUtils.isNotBlank((CharSequence)interfaceName)) {
                interfaze.addSuperInterface(new FullyQualifiedJavaType(interfaceName + "<" + introspectedTable.getBaseRecordType() + ">"));
                interfaze.addImportedType(new FullyQualifiedJavaType(classInfo));
            }
        }
        interfaze.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Component"));
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Mapper"));
        interfaze.addAnnotation("@Mapper");
        interfaze.addAnnotation("@Component");
        interfaze.getMethods().clear();
        return true;
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        String lombok = (String)super.getProperties().get("lombok");
        return !Objects.nonNull(lombok) || !"true".equals(lombok);
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        String lombok = (String)super.getProperties().get("lombok");
        return !Objects.nonNull(lombok) || !"true".equals(lombok);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return true;
    }

    public boolean sqlMapGenerated(GeneratedXmlFile sqlMap, IntrospectedTable introspectedTable) {
        Object obj = super.getProperties().get(CREATE_XML_MAPPER);
        return Objects.nonNull(obj) && "true".equals(String.valueOf(obj));
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return true;
    }

    public boolean sqlMapInsertElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return true;
    }

    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return true;
    }

    public boolean validate(List<String> arg0) {
        Object obj = this.properties.get("mapperSuffix");
        if (Objects.nonNull(obj)) {
            this.suffix = this.properties.getProperty("mapperSuffix");
            return this.suffix != null && this.suffix.length() != 0;
        }
        return true;
    }

    public static void generate() {
        String config = TableDomainAndDaoPlugin.class.getClassLoader().getResource("generatorConfig.xml").getFile();
        String[] arg = new String[]{"-configfile", config, "-overwrite"};
        ShellRunner.main((String[])arg);
    }

    private String replaceSuffix(String old, String primaryKeyPrefix, String primaryKeyPlace) {
        old = old.replace(primaryKeyPrefix, primaryKeyPlace);
        return old;
    }

    public static void main(String[] args) {
        TableDomainAndDaoPlugin.generate();
    }
}

