/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mybatis.generator.plugin;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.DefaultCommentGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCommentGenerator
extends DefaultCommentGenerator {
    private static final Logger log = LoggerFactory.getLogger(TableCommentGenerator.class);
    private Properties properties = new Properties();

    public void addConfigurationProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        String remarks = introspectedColumn.getRemarks();
        StringBuilder sb = new StringBuilder();
        field.addJavaDocLine("/**");
        sb.append(" * ");
        sb.append(remarks);
        field.addJavaDocLine(sb.toString().replace("\n", " "));
        field.addJavaDocLine(" */");
        if (introspectedColumn.isIdentity()) {
            String id = (String)this.properties.get("id");
            if (StringUtils.isNotBlank((CharSequence)id)) {
                String idAnnotation = id.substring(id.lastIndexOf(46) + 1);
                field.addJavaDocLine("@" + idAnnotation + "(\"" + introspectedColumn.getActualColumnName() + "\")");
            }
        } else {
            String column = (String)this.properties.get("column");
            if (StringUtils.isNotBlank((CharSequence)column)) {
                String columnAnnotation = column.substring(column.lastIndexOf(46) + 1);
                field.addJavaDocLine("@" + columnAnnotation + "(\"" + introspectedColumn.getActualColumnName() + "\")");
            }
        }
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String tableAnnotation;
        String column;
        String id;
        String table = (String)this.properties.get("table");
        if (StringUtils.isNotBlank((CharSequence)table)) {
            topLevelClass.addImportedType(table);
        }
        if (StringUtils.isNotBlank((CharSequence)(id = (String)this.properties.get("id"))) && introspectedTable.hasPrimaryKeyColumns()) {
            topLevelClass.addImportedType(id);
        }
        if (StringUtils.isNotBlank((CharSequence)(column = (String)this.properties.get("column")))) {
            topLevelClass.addImportedType(column);
        }
        this.setLombokAnnotationImport(topLevelClass);
        topLevelClass.addJavaDocLine("");
        this.setSerializable(topLevelClass);
        topLevelClass.addJavaDocLine("/**");
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append(introspectedTable.getRemarks());
        sb.append(" ");
        topLevelClass.addJavaDocLine(sb.toString().replace("\n", " "));
        topLevelClass.addJavaDocLine(" */");
        this.setLombokAnnotation(topLevelClass);
        if (StringUtils.isNotBlank((CharSequence)table) && StringUtils.isNotBlank((CharSequence)(tableAnnotation = table.substring(table.lastIndexOf(46) + 1)))) {
            topLevelClass.addJavaDocLine("@" + tableAnnotation + "(\"" + introspectedTable.getFullyQualifiedTableNameAtRuntime() + "\")");
        }
    }

    private void setSerializable(TopLevelClass topLevelClass) {
        Object obj = this.properties.get("serializable");
        if (Objects.nonNull(obj) && "true".equals(String.valueOf(obj))) {
            topLevelClass.addImportedType("java.io.Serializable;");
            topLevelClass.addSuperInterface(new FullyQualifiedJavaType("Serializable"));
        }
    }

    private void setLombokAnnotationImport(TopLevelClass topLevelClass) {
        String lombok = (String)this.properties.get("lombok");
        if (Objects.nonNull(lombok) && "true".equals(lombok)) {
            topLevelClass.addImportedType("lombok.Data;");
        }
    }

    private void setLombokAnnotation(TopLevelClass topLevelClass) {
        String lombok = (String)this.properties.get("lombok");
        if (Objects.nonNull(lombok) && "true".equals(lombok)) {
            topLevelClass.addJavaDocLine("@Data");
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableCommentGenerator)) {
            return false;
        }
        TableCommentGenerator other = (TableCommentGenerator)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableCommentGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "TableCommentGenerator(properties=" + this.getProperties() + ")";
    }
}

