package com.bruce.tool.mybatis.generator.plugin;

import com.bruce.tool.common.util.string.StringUtils;
import org.mybatis.generator.api.*;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.XmlElement;

import java.util.List;
import java.util.Objects;

public class TableDomainAndDaoPlugin extends PluginAdapter {

	private static final String CREATE_XML_MAPPER = "createXmlMapper";
	private static final String PRIMARY_KEY_SUFFIX = "PrimaryKey";
	private static final String PRIMARY_KEY_PLACE = "Id";
	private static final String EXAMPLE_KEY_SUFFIX = "Example";
	private static final String EXAMPLE_KEY_PLACE = "Params";
	private String suffix;

	@Override
	public void initialized(IntrospectedTable introspectedTable) {
		String old = introspectedTable.getMyBatis3JavaMapperType();
		old = replaceSuffix(old, "Mapper", suffix);
		introspectedTable.setMyBatis3JavaMapperType(old);

		old = introspectedTable.getMyBatis3XmlMapperFileName();
		old = replaceSuffix(old, "Mapper", suffix);
		introspectedTable.setMyBatis3XmlMapperFileName(old);

		old = introspectedTable.getSelectByPrimaryKeyStatementId();
		old = replaceSuffix(old, "selectByPrimaryKey", "findOne");
		introspectedTable.setSelectByPrimaryKeyStatementId(old);

		old = introspectedTable.getUpdateByPrimaryKeyWithBLOBsStatementId();
		old = replaceSuffix(old, "updateByPrimaryKeyWithBLOBs", "updateByIdWithBLOBs");
		introspectedTable.setUpdateByPrimaryKeyWithBLOBsStatementId(old);

		old = introspectedTable.getUpdateByPrimaryKeyStatementId();
		old = replaceSuffix(old, PRIMARY_KEY_SUFFIX, PRIMARY_KEY_PLACE);
		introspectedTable.setUpdateByPrimaryKeyStatementId(old);

		old = introspectedTable.getDeleteByPrimaryKeyStatementId();
		old = replaceSuffix(old, PRIMARY_KEY_SUFFIX, PRIMARY_KEY_PLACE);
		introspectedTable.setDeleteByPrimaryKeyStatementId(old);

		old = introspectedTable.getSelectAllStatementId();
		old = replaceSuffix(old, PRIMARY_KEY_SUFFIX, PRIMARY_KEY_PLACE);
		introspectedTable.setSelectAllStatementId(old);

		old = introspectedTable.getUpdateByPrimaryKeySelectiveStatementId();
		old = replaceSuffix(old, PRIMARY_KEY_SUFFIX, PRIMARY_KEY_PLACE);
		introspectedTable.setUpdateByPrimaryKeySelectiveStatementId(old);

		old = introspectedTable.getSelectByExampleStatementId();
		old = replaceSuffix(old, EXAMPLE_KEY_SUFFIX, EXAMPLE_KEY_PLACE);
		introspectedTable.setSelectByExampleStatementId(old);

		old = introspectedTable.getUpdateByExampleStatementId();
		old = replaceSuffix(old, EXAMPLE_KEY_SUFFIX, EXAMPLE_KEY_PLACE);
		introspectedTable.setUpdateByExampleStatementId(old);

		old = introspectedTable.getDeleteByExampleStatementId();
		old = replaceSuffix(old, EXAMPLE_KEY_SUFFIX, EXAMPLE_KEY_PLACE);
		introspectedTable.setDeleteByExampleStatementId(old);

		old = introspectedTable.getUpdateByExampleSelectiveStatementId();
		old = replaceSuffix(old, EXAMPLE_KEY_SUFFIX, EXAMPLE_KEY_PLACE);
		introspectedTable.setUpdateByExampleSelectiveStatementId(old);
		super.initialized(introspectedTable);
	}

	/**生成dao**/
	@Override
	public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
		Object createDao = super.getProperties().get("createDao");
		if(Objects.isNull(createDao) || "false".equals(String.valueOf(createDao)) ){
			return false;
		}

		Object createXmlMapper = super.getProperties().get(CREATE_XML_MAPPER);
		if(Objects.nonNull(createXmlMapper) && "true".equals(String.valueOf(createXmlMapper)) ){
			return true;
		}

		// 设置自定义接口
		Object interfaces = super.getProperties().get("interface");
		if( Objects.nonNull(interfaces) && (interfaces instanceof String) ){
			String classInfo = (String)interfaces;
			if(StringUtils.isNotBlank(classInfo)){
				String interfaceName = classInfo;
				if( classInfo.contains(".") ){
					interfaceName = classInfo.substring(classInfo.lastIndexOf('.')+1,classInfo.length());
				}
				if(StringUtils.isNotBlank(interfaceName)){
					interfaze.addSuperInterface(new FullyQualifiedJavaType(interfaceName+"<" + introspectedTable.getBaseRecordType()	+ ">"));// 添加 extends BaseDao<User>
					interfaze.addImportedType(new FullyQualifiedJavaType(classInfo));
				}
			}
		}
		// 添加springboot基本注解,添加mybatis Mapper注解
		interfaze.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Component"));
		interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Mapper"));
		interfaze.addAnnotation("@Mapper");
		interfaze.addAnnotation("@Component");
		interfaze.getMethods().clear();
		return true;
	}

	/**生成实体中每个getter方法**/
	@Override
	public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass,IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {
		// 是否生成getter,setter
		String lombok = (String) super.getProperties().get("lombok");
		return !(Objects.nonNull(lombok) && "true".equals(lombok));
	}

	@Override
	public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {
		// 是否生成getter,setter
		String lombok = (String) super.getProperties().get("lombok");
		return !(Objects.nonNull(lombok) && "true".equals(lombok));
	}

	/**生成实体**/
	@Override
	public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
		return true;
	}

	/**生成mapping*/
	@Override
	public boolean sqlMapGenerated(GeneratedXmlFile sqlMap, IntrospectedTable introspectedTable) {
		Object obj = super.getProperties().get(CREATE_XML_MAPPER);
		if(Objects.nonNull(obj) && "true".equals(String.valueOf(obj)) ){
			return true;
		}
		return false;
	}

	@Override
	public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
		return true;
	}

	@Override
	public boolean sqlMapInsertElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
		return true;
	}

	@Override
	public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
		return true;
	}

	public boolean validate(List<String> arg0) {
		Object obj = properties.get("mapperSuffix");
		if(Objects.nonNull(obj)){
			suffix = properties.getProperty("mapperSuffix");
			return suffix != null && suffix.length() != 0;
		}
		return true;
	}

	public static void generate() {
		String config = TableDomainAndDaoPlugin.class.getClassLoader().getResource("generatorConfig.xml").getFile();
		String[] arg = { "-configfile", config, "-overwrite" };
		ShellRunner.main(arg);
	}

	private String replaceSuffix(String old, String primaryKeyPrefix, String primaryKeyPlace) {
		old = old.replace(primaryKeyPrefix, primaryKeyPlace);
		return old;
	}

	public static void main(String[] args) {
		generate();
	}
}