package com.bruce.tool.mybatis.generator.plugin;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.DefaultCommentGenerator;

import java.util.Objects;
import java.util.Properties;

/**
 * 表注释生成到类
 * 功能 :
 * 表注释生成到domain属性中
 * @author : Bruce(刘正航) 上午12:49 2018/3/25
 */
@Data
@Slf4j
public class TableCommentGenerator extends DefaultCommentGenerator {

    private Properties properties;
    public TableCommentGenerator() {
        super();
        properties = new Properties();
    }

    @Override
    public void addConfigurationProperties(Properties properties) {
        this.properties.putAll(properties);
    }

    @Override
    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        String remarks = introspectedColumn.getRemarks();
        StringBuilder sb = new StringBuilder();
        field.addJavaDocLine("/**");
        sb.append(" * ");
        sb.append(remarks);
        field.addJavaDocLine(sb.toString().replace("\n", " "));
        field.addJavaDocLine(" */");
        if( introspectedColumn.isIdentity() ){
            String id = (String) this.properties.get("id");
            if( StringUtils.isNotBlank(id) ){
                String idAnnotation = id.substring(id.lastIndexOf('.')+1);
                field.addJavaDocLine("@"+idAnnotation+"(\""+introspectedColumn.getActualColumnName()+"\")");
            }
        }else{
            String column = (String) this.properties.get("column");
            if( StringUtils.isNotBlank(column) ){
                String columnAnnotation = column.substring(column.lastIndexOf('.')+1);
                field.addJavaDocLine("@"+columnAnnotation+"(\""+introspectedColumn.getActualColumnName()+"\")");
            }
        }
    }

    @Override
    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String table = (String) this.properties.get("table");
        if(StringUtils.isNotBlank(table) ){
            topLevelClass.addImportedType(table);
        }

        // 如果有主键,则加入@Id注解
        String id = (String) this.properties.get("id");
        if( StringUtils.isNotBlank(id) && introspectedTable.hasPrimaryKeyColumns() ){
            topLevelClass.addImportedType(id);
        }

        String column = (String) this.properties.get("column");
        if(StringUtils.isNotBlank(column) ){
            topLevelClass.addImportedType(column);
        }

        // 设置使用lombok
        setLombokAnnotationImport(topLevelClass);

        topLevelClass.addJavaDocLine("");
        // 设置序列化接口
        setSerializable(topLevelClass);

        topLevelClass.addJavaDocLine("/**");
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append(introspectedTable.getRemarks());
        sb.append(" ");
        topLevelClass.addJavaDocLine(sb.toString().replace("\n", " "));
        topLevelClass.addJavaDocLine(" */");
        setLombokAnnotation(topLevelClass);
        if(StringUtils.isNotBlank(table) ){
            String tableAnnotation = table.substring(table.lastIndexOf('.')+1);
            if( StringUtils.isNotBlank(tableAnnotation) ){
                topLevelClass.addJavaDocLine("@"+tableAnnotation+"(\""+introspectedTable.getFullyQualifiedTableNameAtRuntime()+"\")");
            }
        }
    }

    /**添加序列化标志**/
    private void setSerializable(TopLevelClass topLevelClass) {
        Object obj = properties.get("serializable");
        if(Objects.nonNull(obj) && "true".equals(String.valueOf(obj)) ){
            topLevelClass.addImportedType("java.io.Serializable;");
            topLevelClass.addSuperInterface(new FullyQualifiedJavaType("Serializable"));
        }
    }

    /**设置使用lombok**/
    private void setLombokAnnotationImport(TopLevelClass topLevelClass) {
        String lombok = (String) this.properties.get("lombok");
        if( Objects.nonNull(lombok) && "true".equals(lombok) ){
            topLevelClass.addImportedType("lombok.Data;");
        }
    }

    /**设置使用lombok**/
    private void setLombokAnnotation(TopLevelClass topLevelClass) {
        String lombok = (String) this.properties.get("lombok");
        if( Objects.nonNull(lombok) && "true".equals(lombok) ){
            topLevelClass.addJavaDocLine("@Data");
        }
    }

}