/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mq.rocket.util;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.mq.rocket.config.RocketConfig;
import com.bruce.tool.mq.rocket.constant.RocketCode;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;

public class RocketUtils {
    public static DefaultMQProducer initSender(RocketConfig config) {
        DefaultMQProducer producer;
        try {
            producer = new DefaultMQProducer(config.getGroup());
            producer.setNamesrvAddr(config.getUrl());
            producer.start();
        }
        catch (MQClientException e) {
            throw new BaseRuntimeException((Object)RocketCode.MQERROR_SENDER_NULL, "\u6d88\u606f\u53d1\u9001\u8005\u521d\u59cb\u5316\u5931\u8d25");
        }
        return producer;
    }

    public static DefaultMQPushConsumer initReceiver(RocketConfig config) {
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(config.getGroup());
        consumer.setNamesrvAddr(config.getUrl());
        return consumer;
    }

    private RocketUtils() {
    }
}

