/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mq.rocket.domain;

import java.util.Arrays;

public class RocketResponse {
    private String topic;
    private String messageId;
    private byte[] body;
    private long timestamp;

    RocketResponse(String topic, String messageId, byte[] body, long timestamp) {
        this.topic = topic;
        this.messageId = messageId;
        this.body = body;
        this.timestamp = timestamp;
    }

    public static RocketResponseBuilder builder() {
        return new RocketResponseBuilder();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public byte[] getBody() {
        return this.body;
    }

    public static class RocketResponseBuilder {
        private String topic;
        private String messageId;
        private byte[] body;
        private long timestamp;

        RocketResponseBuilder() {
        }

        public RocketResponseBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public RocketResponseBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public RocketResponseBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public RocketResponseBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public RocketResponse build() {
            return new RocketResponse(this.topic, this.messageId, this.body, this.timestamp);
        }

        public String toString() {
            return "RocketResponse.RocketResponseBuilder(topic=" + this.topic + ", messageId=" + this.messageId + ", body=" + Arrays.toString(this.body) + ", timestamp=" + this.timestamp + ")";
        }
    }
}

