/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mq.rocket.core;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.mq.rocket.config.RocketConfig;
import com.bruce.tool.mq.rocket.constant.RocketCode;
import com.bruce.tool.mq.rocket.constant.RocketPool;
import com.bruce.tool.mq.rocket.domain.RocketMessage;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RocketSender {
    private static final Logger log = LoggerFactory.getLogger(RocketSender.class);
    @Autowired
    private RocketPool pool;

    public void execute(RocketMessage rocketMessage) {
        this.execute(rocketMessage, null);
    }

    public void execute(RocketMessage rocketMessage, SendCallback callback) {
        DefaultMQProducer producer = this.pool.getSenders().get(rocketMessage.getCode());
        if (Objects.isNull(producer)) {
            throw new BaseRuntimeException((Object)RocketCode.MQERROR_CONFIG_NULL.getCode(), RocketCode.MQERROR_CONFIG_NULL.getMessage());
        }
        RocketConfig config = this.pool.getConfigs().get(rocketMessage.getCode());
        if (Objects.isNull(config)) {
            throw new BaseRuntimeException((Object)RocketCode.MQERROR_SENDER_NULL.getCode(), RocketCode.MQERROR_SENDER_NULL.getMessage());
        }
        Message message = this.buildMessage(rocketMessage, config);
        if (Objects.nonNull(callback)) {
            this.async(producer, message, callback);
        }
        this.sync(producer, message);
    }

    private void sync(DefaultMQProducer producer, Message message) {
        try {
            SendResult sendResult = producer.send(message);
            LogUtils.debug((Logger)log, (Object)JsonUtils.objToStr((Object)sendResult));
        }
        catch (MQBrokerException | MQClientException | RemotingException e) {
            throw new BaseRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new BaseRuntimeException((Throwable)e);
        }
    }

    private void async(DefaultMQProducer producer, Message message, SendCallback callback) {
        producer.setRetryTimesWhenSendAsyncFailed(0);
        try {
            producer.send(message, callback);
        }
        catch (MQClientException | RemotingException e) {
            throw new BaseRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new BaseRuntimeException((Throwable)e);
        }
    }

    private Message buildMessage(RocketMessage rocketMessage, RocketConfig config) {
        Message message = new Message(config.getTopic(), config.getTags(), rocketMessage.getBody());
        if (StringUtils.isNotBlank((CharSequence)rocketMessage.getKey())) {
            message.setKeys(rocketMessage.getKey());
        }
        return message;
    }
}

