/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mq.rocket.constant;

import com.bruce.tool.mq.rocket.config.RocketConfig;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.producer.DefaultMQProducer;

public class RocketPool {
    private Map<String, RocketConfig> configs = Maps.newHashMap();
    private Map<String, DefaultMQProducer> senders = Maps.newHashMap();
    private Map<String, DefaultMQPushConsumer> receivers = Maps.newHashMap();

    public void config(String code, RocketConfig config) {
        this.configs.put(code, config);
    }

    public void sender(String code, DefaultMQProducer producer) {
        this.senders.put(code, producer);
    }

    public void receiver(String code, DefaultMQPushConsumer consumer) {
        this.receivers.put(code, consumer);
    }

    private RocketPool() {
    }

    public static RocketPool build() {
        return new RocketPool();
    }

    public Map<String, RocketConfig> getConfigs() {
        return this.configs;
    }

    public Map<String, DefaultMQProducer> getSenders() {
        return this.senders;
    }

    public Map<String, DefaultMQPushConsumer> getReceivers() {
        return this.receivers;
    }
}

