/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mq.rocket.config;

import com.bruce.tool.mq.rocket.config.RocketConfig;
import com.bruce.tool.mq.rocket.constant.RocketPool;
import com.bruce.tool.mq.rocket.util.RocketUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties
@ConfigurationProperties(prefix="tool.mqs.rocket")
public class RocketsConfig {
    private List<RocketConfig> configs = new ArrayList<RocketConfig>();

    @Bean
    public RocketPool init() {
        return this.initConfig();
    }

    private RocketPool initConfig() {
        RocketPool pool = RocketPool.build();
        for (RocketConfig config : this.configs) {
            String code = config.getCode();
            pool.config(code, config);
            pool.sender(code, RocketUtils.initSender(config));
            pool.receiver(code, RocketUtils.initReceiver(config));
        }
        return pool;
    }

    public List<RocketConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<RocketConfig> configs) {
        this.configs = configs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RocketsConfig)) {
            return false;
        }
        RocketsConfig other = (RocketsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RocketConfig> this$configs = this.getConfigs();
        List<RocketConfig> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RocketsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RocketConfig> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public String toString() {
        return "RocketsConfig(configs=" + this.getConfigs() + ")";
    }
}

