/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mq.aliyun.util;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.bruce.tool.mq.aliyun.config.AliMQConfig;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class AliMQUtils {
    public static Producer initSender(AliMQConfig config) {
        Properties properties = new Properties();
        properties.setProperty("GROUP_ID", config.getGroup());
        properties.put("AccessKey", config.getAccess());
        properties.put("SecretKey", config.getSecret());
        properties.setProperty("SendMsgTimeoutMillis", "3000");
        properties.put("NAMESRV_ADDR", config.getUrl());
        Producer producer = ONSFactory.createProducer((Properties)properties);
        producer.start();
        return producer;
    }

    public static Consumer initReceiver(AliMQConfig config) {
        Properties properties = new Properties();
        properties.put("GROUP_ID", config.getGroup());
        properties.put("AccessKey", config.getAccess());
        properties.put("SecretKey", config.getSecret());
        properties.put("NAMESRV_ADDR", config.getUrl());
        if (StringUtils.isNotBlank((CharSequence)config.getModel()) && "BROADCASTING".equals(config.getModel())) {
            properties.put("MessageModel", "BROADCASTING");
        }
        return ONSFactory.createConsumer((Properties)properties);
    }

    private AliMQUtils() {
    }
}

