/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mq.aliyun.core;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.common.util.valid.ValidUtils;
import com.bruce.tool.mq.aliyun.config.AliMQConfig;
import com.bruce.tool.mq.aliyun.constant.AliMQCode;
import com.bruce.tool.mq.aliyun.constant.AliMQPool;
import com.bruce.tool.mq.aliyun.domain.AliMessage;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliSender {
    private static final Logger log = LoggerFactory.getLogger(AliSender.class);
    @Autowired
    private AliMQPool pool;

    public void execute(AliMessage message) {
        this.execute(message, null);
    }

    public void execute(AliMessage message, SendCallback callback) {
        ValidUtils.valid((Object)message);
        AliMQConfig config = this.pool.getConfigs().get(message.getCode());
        if (Objects.isNull(config)) {
            throw new BaseRuntimeException((Object)AliMQCode.MQERROR_CONFIG_NULL.getCode(), AliMQCode.MQERROR_CONFIG_NULL.getMessage());
        }
        Producer producer = this.pool.getSenders().get(message.getCode());
        if (Objects.isNull(producer)) {
            throw new BaseRuntimeException((Object)AliMQCode.MQERROR_SENDER_NULL.getCode(), AliMQCode.MQERROR_SENDER_NULL.getMessage());
        }
        Message msg = this.buildMessage(message, config);
        if (Objects.nonNull(callback)) {
            this.async(producer, msg, callback);
            return;
        }
        this.sync(producer, msg);
    }

    private void sync(Producer producer, Message msg) {
        try {
            SendResult sendResult = producer.send(msg);
            LogUtils.debug((Logger)log, (Object)JsonUtils.objToStr((Object)sendResult));
        }
        catch (Exception e) {
            throw new BaseRuntimeException((Object)AliMQCode.MQERROR_SEND_EXCEPTION.getCode(), AliMQCode.MQERROR_SEND_EXCEPTION.getMessage());
        }
    }

    private void async(Producer producer, Message msg, SendCallback callback) {
        producer.sendAsync(msg, callback);
    }

    private Message buildMessage(AliMessage message, AliMQConfig config) {
        Message msg = new Message(config.getTopic(), config.getTags(), message.getBody());
        if (StringUtils.isNotBlank((CharSequence)message.getKey())) {
            msg.setKey(message.getKey());
        }
        return msg;
    }
}

