/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mq.aliyun.core;

import com.aliyun.openservices.ons.api.Consumer;
import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.mq.aliyun.config.AliMQConfig;
import com.bruce.tool.mq.aliyun.constant.AliMQCode;
import com.bruce.tool.mq.aliyun.constant.AliMQPool;
import com.bruce.tool.mq.aliyun.domain.AliResponse;
import com.bruce.tool.mq.aliyun.handler.AliMQHandler;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliReceiver {
    @Autowired
    private AliMQPool pool;

    public void origin(String code, AliMQHandler handler) {
        this.execute(code, handler, true);
    }

    public void execute(String code, AliMQHandler handler) {
        this.execute(code, handler, false);
    }

    private void execute(String code, AliMQHandler handler, boolean isBase) {
        AliMQConfig config = this.pool.getConfigs().get(code);
        if (Objects.isNull(config)) {
            throw new BaseRuntimeException((Object)AliMQCode.MQERROR_CONFIG_NULL.getCode(), AliMQCode.MQERROR_CONFIG_NULL.getMessage());
        }
        Consumer consumer = this.pool.getReceivers().get(code);
        if (Objects.isNull(consumer)) {
            throw new BaseRuntimeException((Object)AliMQCode.MQERROR_RECEIVE_NULL.getCode(), AliMQCode.MQERROR_RECEIVE_NULL.getMessage());
        }
        consumer.unsubscribe(config.getTopic());
        consumer.shutdown();
        if (isBase) {
            handler.handle(consumer);
            consumer.start();
            return;
        }
        consumer.subscribe(config.getTopic(), config.getTags(), (message, context) -> handler.handle(AliResponse.builder().topic(message.getTopic()).messageId(message.getMsgID()).body(message.getBody()).build()));
        consumer.start();
    }
}

