/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mq.aliyun.config;

import com.bruce.tool.mq.aliyun.config.AliMQConfig;
import com.bruce.tool.mq.aliyun.constant.AliMQPool;
import com.bruce.tool.mq.aliyun.util.AliMQUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties
@ConfigurationProperties(prefix="tool.mqs.aliyun")
public class AliMQsConfig {
    private List<AliMQConfig> configs = new ArrayList<AliMQConfig>();

    @Bean
    public AliMQPool init() {
        return this.initConfig();
    }

    private AliMQPool initConfig() {
        AliMQPool pool = AliMQPool.build();
        for (AliMQConfig config : this.configs) {
            String code = config.getCode();
            pool.config(code, config);
            pool.sender(code, AliMQUtils.initSender(config));
            pool.receiver(code, AliMQUtils.initReceiver(config));
        }
        return pool;
    }

    public List<AliMQConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<AliMQConfig> configs) {
        this.configs = configs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AliMQsConfig)) {
            return false;
        }
        AliMQsConfig other = (AliMQsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AliMQConfig> this$configs = this.getConfigs();
        List<AliMQConfig> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AliMQsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AliMQConfig> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public String toString() {
        return "AliMQsConfig(configs=" + this.getConfigs() + ")";
    }
}

