/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mail.core;

import com.bruce.tool.mail.config.MailConfig;
import com.bruce.tool.mail.core.Mail;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="mailAdapter")
public class MailAdapter {
    @Autowired
    private MailConfig mailConfig;
    private Mail mail = Mail.create();

    private void init() {
        this.mail.host(this.mailConfig.getHost()).auth(this.mailConfig.getUsername(), this.mailConfig.getPassword()).secret(this.mailConfig.getSecret()).copy(this.mailConfig.getCopy()).to(this.mailConfig.getTo());
    }

    public MailAdapter setTo(String to) {
        this.mailConfig.setTo(to);
        return this;
    }

    public MailAdapter setCopy(String copy) {
        this.mailConfig.setCopy(copy);
        return this;
    }

    public MailAdapter setSecret(String secret) {
        this.mailConfig.setSecret(secret);
        return this;
    }

    public MailAdapter addTo(String to) {
        this.mailConfig.setTo(this.mailConfig.getTo() + ";" + to);
        return this;
    }

    public MailAdapter addCopy(String copy) {
        this.mailConfig.setCopy(this.mailConfig.getCopy() + ";" + copy);
        return this;
    }

    public MailAdapter addSecret(String secret) {
        this.mailConfig.setSecret(this.mailConfig.getSecret() + ";" + secret);
        return this;
    }

    public MailAdapter setSubject(String subject) {
        this.mail.subject(subject);
        return this;
    }

    public MailAdapter setContent(String content) {
        this.mail.content(content);
        return this;
    }

    public MailAdapter addPicture(String pid, String url) {
        this.mail.picture(pid, url);
        return this;
    }

    public MailAdapter addPictures(Map<String, String> pictures) {
        this.mail.pictures(pictures);
        return this;
    }

    public MailAdapter addAttachment(String pid, String url) {
        this.mail.attachment(pid, url);
        return this;
    }

    public MailAdapter addAttachments(Map<String, String> attachments) {
        this.mail.attachments(attachments);
        return this;
    }

    public MailAdapter addByteAttachment(String pid, byte[] bytes) {
        this.mail.byteAttachment(pid, bytes);
        return this;
    }

    public MailAdapter addByteAttachments(Map<String, byte[]> attachments) {
        this.mail.byteAttachments(attachments);
        return this;
    }

    public MailAdapter appendToContent(boolean append) {
        this.mail.appendToContent(append);
        return this;
    }

    public void send() {
        this.init();
        this.mail.send();
    }
}

