/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mail.core;

import com.bruce.tool.common.util.valid.ValidUtils;
import com.bruce.tool.mail.auth.AuthAdapter;
import com.bruce.tool.mail.exception.MailException;
import com.bruce.tool.office.excel.util.ContentUtils;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.validation.constraints.NotNull;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.CollectionUtils;

public class Mail {
    private static final Logger log = LoggerFactory.getLogger(Mail.class);
    @NotNull(message="\u90ae\u7bb1\u670d\u52a1\u5668\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u90ae\u7bb1\u670d\u52a1\u5668\u4e0d\u80fd\u4e3a\u7a7a") String host = "";
    @NotNull(message="\u90ae\u7bb1\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u90ae\u7bb1\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a") String username = "";
    @NotNull(message="\u90ae\u7bb1\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u90ae\u7bb1\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password = "";
    @NotNull(message="\u53d1\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u53d1\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a") String from = "";
    @NotNull(message="\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a") String to = "";
    private String copy = "";
    private String secret = "";
    @NotNull(message="\u90ae\u4ef6\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u90ae\u4ef6\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a") String subject = "";
    @NotNull(message="\u90ae\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u90ae\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a") String content = "";
    private Map<String, String> pictures = new HashMap<String, String>(0);
    private Map<String, String> attachments = new HashMap<String, String>(0);
    private Map<String, byte[]> byteAttachments = new HashMap<String, byte[]>(0);
    private boolean appendToContent;

    public Mail auth(String username, String password) {
        this.from = username;
        this.username = username;
        this.password = password;
        return this;
    }

    public Mail host(String host) {
        this.host = host;
        return this;
    }

    public Mail to(String to) {
        this.to = to;
        return this;
    }

    public Mail copy(String copy) {
        this.copy = copy;
        return this;
    }

    public Mail secret(String secret) {
        this.secret = secret;
        return this;
    }

    public Mail subject(String subject) {
        this.subject = subject;
        return this;
    }

    public Mail content(String content) {
        this.content = content;
        return this;
    }

    public Mail pictures(Map<String, String> pictures) {
        if (CollectionUtils.isEmpty(pictures)) {
            return this;
        }
        this.pictures = pictures;
        return this;
    }

    public Mail picture(String pid, String url) {
        if (StringUtils.isBlank((CharSequence)pid) || StringUtils.isBlank((CharSequence)url)) {
            return this;
        }
        this.pictures.put(pid, url);
        return this;
    }

    public Mail attachments(Map<String, String> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return this;
        }
        this.attachments = attachments;
        return this;
    }

    public Mail attachment(String pid, String url) {
        if (StringUtils.isBlank((CharSequence)pid) || StringUtils.isBlank((CharSequence)url)) {
            return this;
        }
        this.attachments.put(pid, url);
        return this;
    }

    public Mail byteAttachments(Map<String, byte[]> byteAttachments) {
        if (CollectionUtils.isEmpty(byteAttachments)) {
            return this;
        }
        this.byteAttachments = byteAttachments;
        return this;
    }

    public Mail byteAttachment(String pid, byte[] bytes) {
        if (StringUtils.isBlank((CharSequence)pid) || Objects.isNull(bytes)) {
            return this;
        }
        this.byteAttachments.put(pid, bytes);
        return this;
    }

    public Mail appendToContent(boolean appendToContent) {
        this.appendToContent = appendToContent;
        return this;
    }

    public void send() {
        ValidUtils.valid((Object)this);
        JavaMailSenderImpl senderImpl = new JavaMailSenderImpl();
        senderImpl.setHost(this.host);
        MimeMessage mailMessage = senderImpl.createMimeMessage();
        try {
            MimeMessageHelper messageHelper = new MimeMessageHelper(mailMessage, true, "UTF-8");
            this.addSessionInfo(senderImpl);
            messageHelper.setFrom(this.from);
            this.addToEmails(messageHelper);
            this.addCopyEmails(messageHelper);
            this.addSecretEmails(messageHelper);
            messageHelper.setSubject(this.subject);
            this.addPictures(messageHelper);
            this.addAttachments(messageHelper);
            this.addByteAttachments(messageHelper);
            this.appendToContent(messageHelper);
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
        senderImpl.send(mailMessage);
    }

    private void addSessionInfo(JavaMailSenderImpl senderImpl) {
        Properties prop = new Properties();
        prop.setProperty("mail.smtp.auth", "true");
        prop.setProperty("mail.smtp.timeout", "25000");
        prop.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        prop.setProperty("mail.smtp.socketFactory.fallback", "false");
        prop.setProperty("mail.smtp.socketFactory.port", "465");
        prop.setProperty("mail.smtp.port", "456");
        AuthAdapter auth = new AuthAdapter(this.username, this.password);
        Session session = Session.getDefaultInstance((Properties)prop, (Authenticator)auth);
        senderImpl.setSession(session);
    }

    private void addByteAttachments(MimeMessageHelper messageHelper) throws MessagingException {
        if (null != this.byteAttachments) {
            for (Map.Entry<String, byte[]> entry : this.byteAttachments.entrySet()) {
                String cid = entry.getKey();
                byte[] byteArray = entry.getValue();
                if (null == cid || null == byteArray) {
                    throw new MailException("\u8bf7\u786e\u8ba4\u6bcf\u4e2a\u9644\u4ef6\u7684ID\u548c\u5185\u5bb9\u662f\u5426\u9f50\u5168\uff01");
                }
                if (byteArray.length == 0) {
                    throw new MailException("\u9644\u4ef6" + cid + "\u4e0d\u5b58\u5728\uff01");
                }
                ByteArrayResource byteResource = new ByteArrayResource(byteArray);
                messageHelper.addAttachment(cid, (InputStreamSource)byteResource);
            }
        }
    }

    private void addAttachments(MimeMessageHelper messageHelper) throws MessagingException {
        if (null != this.attachments) {
            for (Map.Entry<String, String> entry : this.attachments.entrySet()) {
                String cid = entry.getKey();
                String filePath = entry.getValue();
                if (null == cid || null == filePath) {
                    throw new MailException("\u8bf7\u786e\u8ba4\u6bcf\u4e2a\u9644\u4ef6\u7684ID\u548c\u5730\u5740\u662f\u5426\u9f50\u5168\uff01");
                }
                File file = new File(filePath);
                if (!file.exists()) {
                    throw new MailException("\u9644\u4ef6" + filePath + "\u4e0d\u5b58\u5728\uff01");
                }
                String suffix = Files.getFileExtension((String)filePath);
                if (StringUtils.isNotBlank((CharSequence)suffix)) {
                    cid = cid + "." + suffix;
                }
                FileSystemResource fileResource = new FileSystemResource(file);
                messageHelper.addAttachment(cid, (InputStreamSource)fileResource);
            }
        }
    }

    private void addPictures(MimeMessageHelper messageHelper) throws MessagingException {
        if (null != this.pictures) {
            for (Map.Entry<String, String> entry : this.pictures.entrySet()) {
                String cid = entry.getKey();
                String filePath = entry.getValue();
                if (null == cid || null == filePath) {
                    throw new MailException("\u8bf7\u786e\u8ba4\u6bcf\u5f20\u56fe\u7247\u7684ID\u548c\u56fe\u7247\u5730\u5740\u662f\u5426\u9f50\u5168\uff01");
                }
                File file = new File(filePath);
                if (!file.exists()) {
                    throw new MailException("\u56fe\u7247" + filePath + "\u4e0d\u5b58\u5728\uff01");
                }
                FileSystemResource img = new FileSystemResource(file);
                messageHelper.addInline(cid, (Resource)img);
            }
        }
    }

    private void addToEmails(MimeMessageHelper messageHelper) throws MessagingException {
        String[] toEmailArray = StringUtils.split((String)this.to, (String)";");
        if (toEmailArray.length == 0) {
            throw new MailException("\u6536\u4ef6\u4eba\u90ae\u7bb1\u4e0d\u5f97\u4e3a\u7a7a\uff01");
        }
        messageHelper.setTo(toEmailArray);
    }

    private void addCopyEmails(MimeMessageHelper messageHelper) throws MessagingException {
        String[] copyEmailArray = StringUtils.split((String)this.copy, (String)";");
        if (copyEmailArray.length == 0) {
            return;
        }
        messageHelper.setCc(copyEmailArray);
    }

    private void addSecretEmails(MimeMessageHelper messageHelper) throws MessagingException {
        String[] secretEmailArray = StringUtils.split((String)this.secret, (String)";");
        if (secretEmailArray.length == 0) {
            return;
        }
        messageHelper.setBcc(secretEmailArray);
    }

    private void appendToContent(MimeMessageHelper messageHelper) {
        if (this.appendToContent) {
            InputStream in;
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : this.attachments.entrySet()) {
                try {
                    in = new FileInputStream(new File(entry.getValue()));
                    Throwable throwable = null;
                    try {
                        this.appendToContent(builder, in);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new MailException(e);
                }
            }
            for (Map.Entry<String, String> entry : this.byteAttachments.entrySet()) {
                in = new ByteArrayInputStream((byte[])entry.getValue());
                this.appendToContent(builder, in);
            }
            if (StringUtils.isNotBlank((CharSequence)builder.toString())) {
                this.content = this.content + builder.toString();
            }
        }
        try {
            messageHelper.setText(this.content, true);
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
    }

    private void appendToContent(StringBuilder content, InputStream in) {
        if (Objects.isNull(in)) {
            return;
        }
        try {
            String tableContent = ContentUtils.setTableWidth((String)ContentUtils.transfer((InputStream)in));
            if (StringUtils.isNotBlank((CharSequence)tableContent)) {
                content.append("<br/>");
                content.append(tableContent);
                content.append("<br/>");
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MailException(e);
        }
    }

    private Mail() {
    }

    public static Mail create() {
        return new Mail();
    }
}

