/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.mail.constant;

import com.bruce.tool.common.exception.ErrorCode;
import com.bruce.tool.common.exception.I18N;

public enum MailErrorCode {
    MAIL_ERROR("M0001", "\u7f51\u7edc\u5f02\u5e38", "network error");

    private String code;
    private String message;
    private String messageENUS;

    public static String getMessageByCode(String code, I18N i18N) {
        ErrorCode target = MailErrorCode.search(code);
        if (null == target) {
            return "";
        }
        return MailErrorCode.getMessageByLanguage(i18N, target.getMessage(), target.getMessageENUS());
    }

    public static ErrorCode search(String code) {
        ErrorCode target = null;
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (!errorCode.getCode().equals(code)) continue;
            target = errorCode;
        }
        return target;
    }

    public static String getMessageByLanguage(I18N i18N, String ... messages) {
        I18N[] ns = I18N.values();
        Integer size = messages.length;
        String message = messages[0];
        int length = ns.length;
        for (int i = 0; i < length; ++i) {
            if (!i18N.equals((Object)ns[i])) continue;
            message = i < size - 1 ? messages[i] : messages[0];
        }
        return message;
    }

    private MailErrorCode(String code, String message, String messageENUS) {
        this.code = code;
        this.message = message;
        this.messageENUS = messageENUS;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageENUS() {
        return this.messageENUS;
    }
}

