/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.controller.util;

import com.bruce.tool.cache.redis.constant.ExpireTime;
import com.bruce.tool.cache.redis.util.RedisUtils;
import com.bruce.tool.common.exception.ExceptionUtils;
import com.bruce.tool.controller.exception.ExportLimitException;
import com.bruce.tool.controller.util.ByteCallback;
import com.bruce.tool.controller.util.Callback;
import com.bruce.tool.controller.util.LimitCallback;
import com.bruce.tool.controller.util.RequestLimitUtils;
import com.bruce.tool.office.excel.constant.Version;
import com.bruce.tool.office.excel.core.Excels;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DownloadUtils {
    private static final Logger log = LoggerFactory.getLogger(DownloadUtils.class);
    private static ThreadLocal<DownloadConfig> downloadConfig = new ThreadLocal();
    private static final Integer DEFAULT_MAX_DOWNLOAD_NUM = 20000;

    public static void setMaxLine(Integer maxDownload) {
        DownloadConfig config = downloadConfig.get();
        if (null == config) {
            config = new DownloadUtils().new DownloadConfig();
            downloadConfig.set(config);
        }
        config.setMaxDownload(maxDownload);
    }

    public static Integer getMaxLine() {
        Integer maxDownlaod = DEFAULT_MAX_DOWNLOAD_NUM;
        DownloadConfig config = downloadConfig.get();
        if (null != config && null != config.getMaxDownload()) {
            maxDownlaod = config.getMaxDownload();
        }
        return maxDownlaod;
    }

    public static <T> void download(HttpServletResponse response, String fileName, Class<T> clazz, List<T> list) {
        Excels.Export().config(Version.XLSX, Integer.valueOf(5000)).addSheet(list, clazz, fileName).toResponse(response, fileName);
    }

    public static <T> void download(Class<T> clazz, String fileName, HttpServletRequest request, HttpServletResponse response, Callback<T> callback) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException {
        DownloadUtils.download(clazz, null, fileName, request, response, callback);
    }

    public static <T> void download(Class<T> clazz, String methodName, String fileName, HttpServletRequest request, HttpServletResponse response, Callback<T> callback) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (DownloadUtils.fetchDataFromCache(request, response, fileName)) {
            return;
        }
        List<T> list = callback.fetch();
        if (!CollectionUtils.isEmpty(list)) {
            Integer maxDownload = DownloadUtils.getMaxLine();
            if (list.size() > maxDownload) {
                throw new ExportLimitException(maxDownload);
            }
            if (StringUtils.isNotBlank((CharSequence)methodName)) {
                T t = list.get(0);
                Method method = t.getClass().getMethod(methodName, new Class[0]);
                fileName = method.invoke(t, new Object[0]) + fileName;
            }
        }
        byte[] data = DownloadUtils.saveDataToCache(request, fileName, clazz, list);
        DownloadUtils.setExcelDownloadInfo(response, fileName);
        response.getOutputStream().write(data);
        log.debug("\u91cd\u5165\u9501,\u4e0b\u8f7d\u5b8c\u6bd5......................");
    }

    public static void download(String fileName, HttpServletRequest request, HttpServletResponse response, ByteCallback callback) throws IOException {
        if (DownloadUtils.fetchDataFromCache(request, response, fileName)) {
            return;
        }
        byte[] data = callback.fetch();
        DownloadUtils.saveDataToCache(request, fileName, data);
        DownloadUtils.setExcelDownloadInfo(response, fileName);
        response.getOutputStream().write(data);
        log.debug("\u91cd\u5165\u9501,\u4e0b\u8f7d\u5b8c\u6bd5......................");
    }

    public static void validMaxDownload(LimitCallback callback) {
        Page pages = PageHelper.startPage((int)1, (int)1);
        callback.execute();
        Integer maxDownload = DownloadUtils.getMaxLine();
        if (pages.getTotal() > (long)maxDownload.intValue()) {
            throw new ExportLimitException(maxDownload);
        }
        pages.clear();
    }

    public static void setMaxLine(HttpServletResponse response, String fileName) {
        response.setContentType("application/form-data");
        try {
            fileName = new String(fileName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException e) {
            ExceptionUtils.printStackTrace((Throwable)e);
        }
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
    }

    public static void setExcelDownloadInfo(HttpServletResponse response, String fileName) {
        DownloadUtils.setMaxLine(response, fileName + ".xlsx");
    }

    private static void saveDataToCache(HttpServletRequest request, String fileName, byte[] data) {
        String dataKey = RequestLimitUtils.orderData(request, request.getMethod());
        RedisUtils.set((String)dataKey, (Object)data, (ExpireTime)ExpireTime.ONE_MIN);
        String fileNameKey = RequestLimitUtils.orderFileName(request, request.getMethod());
        RedisUtils.set((String)fileNameKey, (Object)fileName, (int)ExpireTime.ONE_MIN.getTime());
    }

    private static <T> byte[] saveDataToCache(HttpServletRequest request, String fileName, Class<T> clazz, List<T> list) {
        String dataKey = RequestLimitUtils.orderData(request, request.getMethod());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Excels.Export().config(Version.XLSX, Integer.valueOf(5000)).addSheet(list, clazz, fileName).toStream((OutputStream)bos);
        byte[] data = bos.toByteArray();
        RedisUtils.set((String)dataKey, (Object)data, (ExpireTime)ExpireTime.ONE_MIN);
        String fileNameKey = RequestLimitUtils.orderFileName(request, request.getMethod());
        RedisUtils.set((String)fileNameKey, (Object)fileName, (int)ExpireTime.ONE_MIN.getTime());
        return data;
    }

    private static boolean fetchDataFromCache(HttpServletRequest request, HttpServletResponse response, String fileName) throws IOException {
        String dataKey = RequestLimitUtils.orderData(request, request.getMethod());
        byte[] bytes = (byte[])RedisUtils.get((String)dataKey);
        if (null != bytes && bytes.length > 0) {
            String fileNameKey = RequestLimitUtils.orderFileName(request, request.getMethod());
            String cacheFileName = (String)RedisUtils.get((String)fileNameKey);
            if (StringUtils.isNotBlank((CharSequence)cacheFileName)) {
                fileName = cacheFileName;
            }
            DownloadUtils.setExcelDownloadInfo(response, fileName);
            response.getOutputStream().write(bytes);
            return true;
        }
        return false;
    }

    public class DownloadConfig {
        private Integer maxDownload;

        public Integer getMaxDownload() {
            return this.maxDownload;
        }

        public void setMaxDownload(Integer maxDownload) {
            this.maxDownload = maxDownload;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DownloadConfig)) {
                return false;
            }
            DownloadConfig other = (DownloadConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maxDownload = this.getMaxDownload();
            Integer other$maxDownload = other.getMaxDownload();
            return !(this$maxDownload == null ? other$maxDownload != null : !((Object)this$maxDownload).equals(other$maxDownload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DownloadConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maxDownload = this.getMaxDownload();
            result = result * 59 + ($maxDownload == null ? 43 : ((Object)$maxDownload).hashCode());
            return result;
        }

        public String toString() {
            return "DownloadUtils.DownloadConfig(maxDownload=" + this.getMaxDownload() + ")";
        }
    }
}

