/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.controller.interceptor;

import com.bruce.tool.cache.redis.constant.ExpireTime;
import com.bruce.tool.cache.redis.util.RedisUtils;
import com.bruce.tool.common.exception.BaseException;
import com.bruce.tool.common.exception.ErrorCode;
import com.bruce.tool.controller.annotation.RequestOrder;
import com.bruce.tool.controller.util.RequestLimitUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component(value="orderInterceptor")
public class OrderInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(OrderInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            RequestOrder requestOrder = (RequestOrder)method.getMethodAnnotation(RequestOrder.class);
            if (requestOrder == null) {
                return true;
            }
            if (this.fetchDownloadFileNameFromCache(request)) {
                return true;
            }
            Long seconds = requestOrder.release();
            String key = RequestLimitUtils.orderKey(request, request.getMethod());
            Object value = RedisUtils.get((String)key);
            log.debug("\u91cd\u5165\u9501,KEY:{}", (Object)key);
            log.debug("\u91cd\u5165\u9501,KEY:{},VALUE:{}", (Object)key, value);
            if (null == value) {
                log.debug("\u91cd\u5165\u9501,KEY:{},\u5f00\u542f...........................", (Object)key);
                RedisUtils.set((String)key, (Object)seconds.toString(), (int)ExpireTime.ONE_MIN.getTime());
                return true;
            }
            log.debug("\u91cd\u5165\u9501,KEY:{},\u6392\u961f...........................", (Object)key);
            throw new BaseException((Object)ErrorCode.RUNNING.getCode(), ErrorCode.RUNNING.getMessage());
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            RequestOrder requestOrder = (RequestOrder)method.getMethodAnnotation(RequestOrder.class);
            if (requestOrder == null) {
                return;
            }
            String key = RequestLimitUtils.orderKey(request, request.getMethod());
            Object value = RedisUtils.get((String)key);
            log.debug("\u91cd\u5165\u9501,KEY:{},afterCompletion", (Object)key);
            log.debug("\u91cd\u5165\u9501,KEY:{},afterCompletion,VALUE:{}", (Object)key, value);
            if (null != value) {
                RedisUtils.delete((String)key);
            }
        }
    }

    private boolean fetchDownloadFileNameFromCache(HttpServletRequest request) throws IOException {
        String fileNameKey = RequestLimitUtils.orderFileName(request, request.getMethod());
        Object fileName = RedisUtils.get((String)fileNameKey);
        if (null != fileName) {
            log.debug("\u91cd\u5165\u9501,KEY:{},\u540c\u65f6\u8fd4\u56de\u7684\u65f6\u5019,\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6570\u636e.....", (Object)fileNameKey);
            return true;
        }
        return false;
    }
}

