/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.controller.interceptor;

import com.bruce.tool.cache.redis.constant.ExpireTime;
import com.bruce.tool.cache.redis.util.RedisUtils;
import com.bruce.tool.common.exception.BaseException;
import com.bruce.tool.common.exception.ErrorCode;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.controller.annotation.RequestDuplicate;
import com.bruce.tool.controller.util.RequestLimitUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component(value="duplicateInterceptor")
public class DuplicateInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(DuplicateInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            RequestDuplicate resubmit = (RequestDuplicate)method.getMethodAnnotation(RequestDuplicate.class);
            if (resubmit == null) {
                return true;
            }
            Long seconds = resubmit.seconds();
            String key = RequestLimitUtils.duplicateKey(request, request.getMethod());
            String value = (String)RedisUtils.get((String)key);
            LogUtils.debug((Logger)log, (String)"\u91cd\u590d\u63d0\u4ea4,KEY:{}", (Object)key);
            LogUtils.debug((Logger)log, (String)"\u91cd\u590d\u63d0\u4ea4,KEY:{},VALUE:{}", (Object[])new Object[]{key, value});
            if (StringUtils.isBlank((CharSequence)value)) {
                RedisUtils.set((String)key, (Object)seconds.toString(), (ExpireTime)ExpireTime.ONE_MIN);
                return true;
            }
            log.error("\u91cd\u590d\u63d0\u4ea4:KEY:{},\u89e6\u53d1\u91cd\u590d\u63d0\u4ea4\u9650\u5236", (Object)key);
            throw new BaseException((Object)ErrorCode.RESUBMIT.getCode(), ErrorCode.RESUBMIT.getMessage());
        }
        return true;
    }
}

